/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.dao;

import gov.va.med.nhin.adapter.subscription.web.entity.Binary;
import java.math.BigDecimal;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

/**
 *
 * @author DNS   VAZQUD
 */
@Named("BinaryDAO")
@ApplicationScoped()
public class BinaryDAO
{
    @PersistenceContext
    private EntityManager entityManager;

    public void store(Binary binary)
    {
        entityManager.persist(binary);
    }

    public void update(Binary binary)
    {
        entityManager.merge(binary);
    }

    public Binary findByBinaryID(BigDecimal binaryID)
    {
        return entityManager.find(Binary.class, binaryID);
    }

    public Binary findByResourceID(String resourceID)
    {
        Binary ret;
        Query query = entityManager.createNamedQuery("Binary.findByResourceId");
        query.setParameter("resourceId", resourceID);
        try {
            ret = (Binary) query.getSingleResult();
        }
        catch (NoResultException nre) {
            ret = null;
        }

        return ret;
    }
}
