var app = angular.module('subscriptionServiceTesterApp', []);

app.config(function () {

});

app.controller('controller', ['$scope', '$http', '$timeout', '$filter', function ($scope, $http, $timeout, $filter) {
        $scope.subscribe = function () {
            $scope.documentReferences = null;
            $scope.nhioStatuses = null;
            $scope.subscriptionID = null;
            $scope.subscriptionStatus = null;
            $scope.lastModified = null;
            $scope.ETag = null;
            var req = {
                resourceType: "Subscription",
                // from Resource: id, meta, implicitRules, and language
                // from DomainResource: text, contained, extension, and modifierExtension
                status: "requested", // R!  requested | active | error | off
                contact: [], // Contact details for source (e.g. troubleshooting)
                end: null, // When to automatically delete the subscription
                reason: "Prefetch", // R!  Description of why this subscription was created
                criteria: "DocumentReference?patient=Patient/" + $scope.patientID, // R!  Rule for server push criteria
                error: "<string>", // Latest error note
                channel: {// R!  The channel on which to report matches to the criteria
                    type: $scope.useWebSocket ? "websocket" : "rest-hook", // R!  rest-hook | websocket | email | sms | message
                    endpoint: !$scope.useWebSocket ? "http://MOCK-HOST:8090/on-notify" : null, // Where the channel points to
                    payload: null, // Mimetype to send, or omit for no payload
                    header: !$scope.useWebSocket ? ["X-TransactionID: DAS-0987654321"] : null // Usage depends on the channel type
                },
                extension: [{
                        url: "http://ehx.DNS   /StructureDefinition/EHXSubscription/announcePatient",
                        valueBoolean: $scope.announce
                    }, {
                        url: "http://ehx.DNS   /StructureDefinition/EHXSubscription/autoDocRetrieve",
                        valueBoolean: $scope.autoDR
                    }, {
                        url: "http://ehx.DNS   /StructureDefinition/EHXSubscription/assertions",
                        extension: [{
                                url: "userID",
                                valueString: "REDACTED"
                            }, {
                                url: "userName",
                                valueString: "User 1-2-3"
                            }, {
                                url: "systemID",
                                valueString: "JLV"
                            }, {
                                url: "organizationID",
                                valueString: "2.16.840.1.113883.4.349.983"
                            }, {
                                url: "organizationName",
                                valueString: "Department of Veterans Affairs - CHYSHR"
                            }, {
                                url: "purposeOfUse",
                                valueString: "TREATMENT"
                            }, {
                                url: "role",
                                valueString: "112247003"
                            }]
                    }]
            };

            $scope.subscriptionTime = $filter('date')(new Date(), 'yyyy-MM-ddTHH:mm:ss', 'UTC') + 'Z';

            $http.post('/AdapterSubscriptionService/FHIR/Subscription', JSON.stringify(req)).then(function (response) {
                $scope.subscriptionLocation = response.headers('Location');

                if ($scope.useWebSocket) {
                    $scope.setupWebSocket();
                }

                $scope.monitorSubscription();
            });
        };

        $scope.monitorSubscription = function () {
            var config = null;
            if ($scope.ETag !== null) {
                config = {headers: {'If-None-Match': $scope.ETag}};
            }
            $http.get($scope.subscriptionLocation, config).then(function (response) {
                $scope.ETag = response.headers('ETag');
                $scope.lastModified = response.headers('Last-Modified');
                var subscription = response.data;
                var nhioStatuses = [];
                for (var i in subscription.extension) {
                    var ext = subscription.extension[i];
                    if (ext.url === 'http://ehx.DNS   /StructureDefinition/EHXSubscription/nhioStatus') {
                        var nhioStatus = ext.extension;
                        var o = {};
                        for (var j in nhioStatus) {
                            var field = nhioStatus[j];
                            switch (field.url) {
                                case 'hcid':
                                    o.hcid = field.valueString;
                                    break;

                                case 'status':
                                    o.status = field.valueCode;
                                    break;

                                case 'type':
                                    o.stage = field.valueCode;
                                    break;

                                default:
                                    break;
                            }
                        }
                        nhioStatuses.push(o);
                    }
                }
                $scope.subscriptionStatus = subscription.status;
                $scope.nhioStatuses = nhioStatuses;
                $scope.subscriptionID = subscription.id;

                $http.get('/AdapterSubscriptionService/FHIR/DocumentReference?patient=Patient/' + $scope.patientID + '&_lastUpdated=>=' + $scope.subscriptionTime).then(function (response) {
                    var bundle = response.data;
                    var documentReferences = [];
                    for (var i in bundle.entry) {
                        var entry = bundle.entry[i].resource;
                        var hcid = "";
                        for (var j in entry.extension) {
                            var ext = entry.extension[j];
                            if (ext.url === "http://ehx.DNS   /StructureDefinition/EHXDocumenteReference/homeCommunityId") {
                                hcid = ext.valueString;
                                break;
                            }
                        }
                        documentReferences.push({
                            hcid: hcid,
                            entry: entry
                        });
                    }
                    $scope.documentReferences = documentReferences;
                });

                if (!$scope.useWebSocket) {
                    if (subscription.status !== 'off') {
                        $timeout($scope.monitorSubscription, 1000);
                    }
                } else {
                    if (subscription.status === 'off') {
                        $scope.tearDownWebSocket();
                    }
                }
            }, function (response) {
                if (!$scope.useWebSocket) {
                    if (response.status === 304) {
                        $timeout($scope.monitorSubscription, 1000);
                    }
                } else {
                    if (response.status !== 304) {
                        $scope.tearDownWebSocket();
                    }
                }
            });
        };

        $scope.setupWebSocket = function () {
            var prot = window.location.protocol === 'https:' ? 'wss' : 'ws';
            var ws = $scope.ws = new WebSocket(prot + '://' + window.location.hostname + ':' + window.location.port + '/AdapterSubscriptionService/SubscriptionWS');

            ws.onopen = function () {
                ws.send('bind ' + $scope.subscriptionLocation.substr($scope.subscriptionLocation.lastIndexOf('/') + 1));
            };

            ws.onerror = function () {
                console.log('An error happened');
            };

            ws.onmessage = function (message) {
                console.log(message.data);
                var data = "" + message.data;
                if (data.indexOf('ping') === 0) {
                    $scope.monitorSubscription();
                }
                else if (data.indexOf('unbound') === 0) {
                    ws.close();
                }
            };

            ws.onclose = function () {
                console.log('WebSocket closed');
                if ($scope.subscriptionStatus !== 'off') {
                    $scope.monitorSubscription();
                    console.log('  Re-connecting.');
                    $timeout($scope.setupWebSocket, 500);
                }
            };
        };
        
        $scope.tearDownWebSocket = function() {
            $scope.ws.send('unbind ' + $scope.subscriptionLocation.substr($scope.subscriptionLocation.lastIndexOf('/') + 1));
        };
    }]);
