/**
 *
 */
package gov.va.med.nhin.adapter.datamanager.translators;

import gov.va.med.nhin.adapter.datamanager.DataDate;
import gov.va.med.nhin.adapter.datamanager.TestReference;

import java.math.BigDecimal;

import static org.junit.Assert.assertEquals;
import org.junit.Test;
import org.slf4j.LoggerFactory;

/**
 * @author vhaiswchmarc
 *
 */
public class FileManDateUnfilteredDataTranslatorTest {

	final static BigDecimal YEAR = BigDecimal.valueOf( 3030000 );
	final static BigDecimal MONTH = BigDecimal.valueOf( 3031100 );
	final static BigDecimal DAY = BigDecimal.valueOf( 3031120 );
	final static BigDecimal TIME_PM = BigDecimal.valueOf( 3031120.1826 );
	final static BigDecimal TIME_AM = BigDecimal.valueOf( 3031120.0626 );
	final static BigDecimal SECOND = BigDecimal.valueOf( 3031120.182623 );

	/**
	 * Test method for
	 * {@link gov.va.med.nhin.adapter.datamanager.translators.FileManDateUnfilteredDataTranslator#translate(java.lang.Object, java.lang.Object, gov.va.med.nhin.adapter.datamanager.Reference, gov.va.med.nhin.adapter.datamanager.DataQuery)}.
	 */
	@Test
	public final void testPrettyTranslatehourtosecond() {
		TestReference ref = new TestReference();
		String ret = parseDate( YEAR, ref );
		assertEquals( "2003", ret );
		ret = parseDate( MONTH, ref );
		assertEquals( "Nov 2003", ret );
		ret = parseDate( DAY, ref );
		assertEquals( "Nov 20, 2003", ret );
		ret = parseDate( TIME_PM, ref );
		assertEquals( "Nov 20, 2003, 06:26 PM", ret );
		ret = parseDate( TIME_AM, ref );
		assertEquals( "Nov 20, 2003, 06:26 AM", ret );
		ret = parseDate( SECOND, ref );
		assertEquals( "Nov 20, 2003, 06:26 PM", ret );
	}

	@Test
	public final void testPrettyTranslatehourtominute() {
		TestReference ref = new TestReference();
		ref.setProperty( "targetDateFormat", "yyyy MMM dd hh:mm a" );
		String ret = parseDate( YEAR, ref );
		assertEquals( "2003", ret );
		ret = parseDate( MONTH, ref );
		assertEquals( "2003 Nov", ret );
		ret = parseDate( DAY, ref );
		assertEquals( "2003 Nov 20", ret );
		ret = parseDate( TIME_PM, ref );
		assertEquals( "2003 Nov 20 06:26 PM", ret );
		ret = parseDate( TIME_AM, ref );
		assertEquals( "2003 Nov 20 06:26 AM", ret );
		ret = parseDate( SECOND, ref );
		assertEquals( "2003 Nov 20 06:26 PM", ret );
	}

	@Test
	public final void testPrettyTranslatehourtosecond24() {
		TestReference ref = new TestReference();
		ref.setProperty( "targetDateFormat", "yyyy MMM dd HH:mm.ss" );
		String ret = parseDate( YEAR, ref );
		assertEquals( "2003", ret );
		ret = parseDate( MONTH, ref );
		assertEquals( "2003 Nov", ret );
		ret = parseDate( DAY, ref );
		assertEquals( "2003 Nov 20", ret );
		ret = parseDate( TIME_PM, ref );
		assertEquals( "2003 Nov 20 18:26.00", ret );
		ret = parseDate( TIME_AM, ref );
		assertEquals( "2003 Nov 20 06:26.00", ret );
		ret = parseDate( SECOND, ref );
		assertEquals( "2003 Nov 20 18:26.23", ret );
	}

	@Test
	public final void testPrettyTranslatehourtominute24() {
		TestReference ref = new TestReference();
		ref.setProperty( "targetDateFormat", "yyyy MMM dd HH:mm" );
		String ret = parseDate( YEAR, ref );
		assertEquals( "2003", ret );
		ret = parseDate( MONTH, ref );
		assertEquals( "2003 Nov", ret );
		ret = parseDate( DAY, ref );
		assertEquals( "2003 Nov 20", ret );
		ret = parseDate( TIME_PM, ref );
		assertEquals( "2003 Nov 20 18:26", ret );
		ret = parseDate( TIME_AM, ref );
		assertEquals( "2003 Nov 20 06:26", ret );
		ret = parseDate( SECOND, ref );
		assertEquals( "2003 Nov 20 18:26", ret );
	}

	@Test
	public final void testTranslatehourtosecond() {
		TestReference ref = new TestReference();
		ref.setProperty( "targetDateFormat", "yyyyMMddhhmmss" );
		String ret = parseDate( YEAR, ref );
		assertEquals( "2003", ret );
		ret = parseDate( MONTH, ref );
		assertEquals( "200311", ret );
		ret = parseDate( DAY, ref );
		assertEquals( "20031120", ret );
		ret = parseDate( TIME_PM, ref );
		assertEquals( "20031120062600", ret );
		ret = parseDate( TIME_AM, ref );
		assertEquals( "20031120062600", ret );
		ret = parseDate( SECOND, ref );
		assertEquals( "20031120062623", ret );
	}

	@Test
	public final void testTranslatehourtominute() {
		TestReference ref = new TestReference();
		ref.setProperty( "targetDateFormat", "yyyyMMddhhmm" );
		String ret = parseDate( YEAR, ref );
		assertEquals( "2003", ret );
		ret = parseDate( MONTH, ref );
		assertEquals( "200311", ret );
		ret = parseDate( DAY, ref );
		assertEquals( "20031120", ret );
		ret = parseDate( TIME_PM, ref );
		assertEquals( "200311200626", ret );
		ret = parseDate( TIME_AM, ref );
		assertEquals( "200311200626", ret );
		ret = parseDate( SECOND, ref );
		assertEquals( "200311200626", ret );
	}

	@Test
	public final void testTranslatehourtosecond24() {
		TestReference ref = new TestReference();
		ref.setProperty( "targetDateFormat", "yyyyMMddHHmmss" );
		String ret = parseDate( YEAR, ref );
		assertEquals( "2003", ret );
		ret = parseDate( MONTH, ref );
		assertEquals( "200311", ret );
		ret = parseDate( DAY, ref );
		assertEquals( "20031120", ret );
		ret = parseDate( TIME_PM, ref );
		assertEquals( "20031120182600", ret );
		ret = parseDate( TIME_AM, ref );
		assertEquals( "20031120062600", ret );
		ret = parseDate( SECOND, ref );
		assertEquals( "20031120182623", ret );
	}

	@Test
	public final void testTranslatehourtominute24() {
		TestReference ref = new TestReference();
		ref.setProperty( "targetDateFormat", "yyyyMMddHHmm" );
		String ret = parseDate( YEAR, ref );
		assertEquals( "2003", ret );
		ret = parseDate( MONTH, ref );
		assertEquals( "200311", ret );
		ret = parseDate( DAY, ref );
		assertEquals( "20031120", ret );
		ret = parseDate( TIME_PM, ref );
		assertEquals( "200311201826", ret );
		ret = parseDate( TIME_AM, ref );
		assertEquals( "200311200626", ret );
		ret = parseDate( SECOND, ref );
		assertEquals( "200311201826", ret );
	}

	private String parseDate( final BigDecimal date, final TestReference ref ) {
		FileManDateUnfilteredDataTranslator trans = new FileManDateUnfilteredDataTranslator();
		DataDate dataDate = (DataDate) trans.translate( date, null, ref, null );
		LoggerFactory.getLogger( getClass() ).debug( dataDate.toString() );
		return dataDate.toString();
	}
}
