package gov.va.med.nhin.adapter.xmlutils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.xml.XMLConstants;
import javax.xml.namespace.NamespaceContext;

/**
 *
 * @author David Vazquez
 */
public class XMLNamespaceContext implements NamespaceContext
{
    private final Map<String, String> namespaceMapping = new HashMap<String, String>();
    private final Map<String, String> reverseMapping = new HashMap<String, String>();

    public void addMapping(String prefix, String namespaceURI)
    {
        namespaceMapping.put(prefix, namespaceURI);
        reverseMapping.put(namespaceURI, prefix);
    }

    public String getNamespaceURI(String prefix)
    {
        String ret = namespaceMapping.get(prefix);
        return ret != null ? ret : XMLConstants.NULL_NS_URI;
    }

    public String getPrefix(String namespaceURI)
    {
        return reverseMapping.get(namespaceURI);
    }

    public Iterator getPrefixes(String namespaceURI)
    {
        List<String> ret = new ArrayList<String>();

        String s = getPrefix(namespaceURI);
        if (s != null) ret.add(s);

        return ret.iterator();
    }
}
