/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.utils.soap.handler;

import gov.va.med.nhin.adapter.logging.LogConstants;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.slf4j.MDC;
import org.w3c.dom.Node;

/**
 *
 * @author david

 TransactionIDSOAPHandler is used to assign a transaction ID to incoming server
 requests so that all logging done in the processing of the request can be
 tied together. This SOAP handler should only be used in server side handler
 chains.
 */
public class TransactionIDSOAPHandler implements SOAPHandler<SOAPMessageContext>
{
    public boolean handleMessage(SOAPMessageContext smc)
    {
        SOAPMessage message = smc.getMessage();
        Boolean isOutbound = (Boolean)smc.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);
        String corrid = null;

        try {
            SOAPHeader headers = message.getSOAPHeader();
            if (!isOutbound) {
                // Inbound request to server.  Look for transaction ID in SOAP header
                // or generate new ID if it's not in the SOAP header.  Stuff the
                // ID in the MDC.
                Iterator<Node> it = headers.getChildElements(LogConstants.CORRELATION_SOAPPROP);
                if (it.hasNext()) {
                    // we have a transaction id in the message headers, so use it
                    Node n = it.next();
                    corrid = n.getTextContent();
                }
                else {
                    // no transaction id in the message headers...was one set in the ctor?
                    corrid = findOrGenTransactionId();
                }

                MDC.put(LogConstants.CORRELATION_MDCKEY, corrid);
            }
            else {
                // Outbound server response.  Put the transaction ID in a SOAP
                // header.
                corrid = MDC.get(LogConstants.CORRELATION_MDCKEY);
                SOAPHeaderElement txnheader
                    = headers.addHeaderElement(LogConstants.CORRELATION_SOAPPROP);
                txnheader.addTextNode(corrid);
            }
        }
        catch (SOAPException se) {
            // don't worry about this for now.
        }

        return true;
    }

    public Set<QName> getHeaders()
    {
        return Collections.EMPTY_SET;
    }

    public boolean handleFault(SOAPMessageContext messageContext)
    {
        return true;
    }

    public void close(MessageContext context)
    {
    }

    private String findOrGenTransactionId()
    {
        return (null == MDC.get(LogConstants.CORRELATION_MDCKEY)
            ? UUID.randomUUID().toString() : (String)MDC.get(LogConstants.CORRELATION_MDCKEY));
    }
}
