package gov.va.med.nhin.adapter.utils.das;

import javax.ws.rs.core.Response;

/**
 *
 * @author KazeninP
 */
public class DasDAOMockImpl implements DasDAO
{
	private String endPoint;

	public DasDAOMockImpl(String endPoint)
	{
		this.endPoint = endPoint;
	}

	public DasOperationSendImmunizationDataResponse doOperationSendImmunizationData(DasOperationSendImmunizationDataRequest req) throws DasException
	{
		String icn = req.getICN();
		String facility = req.getFacility();

		String url = new String(endPoint);
		url = url.replace("[ICN]", icn);
		url = url.replace("[FACILITY]", facility);

		// input icn simulates HTTP Status of the response
		int httpStatus;

		try
		{
			httpStatus = Integer.parseInt(icn);
		}
		catch(NumberFormatException e)
		{
			// non-numeric ICN, default to Success
			httpStatus = Response.Status.CREATED.getStatusCode();
		}

		if(httpStatus == Response.Status.NOT_FOUND.getStatusCode())
		{
			// 404 document not found
			throw new DasException("XDSRegistryError", icn);
		}
		else if(httpStatus == Response.Status.INTERNAL_SERVER_ERROR.getStatusCode())
		{
			// 500 XDS_REGISTRY_ERROR
			throw new DasException("XDSRegistryError", icn);
		}
		else if(httpStatus == Response.Status.BAD_REQUEST.getStatusCode())
		{
			// 400 Bad request
			throw new DasException("XDSRegistryError", icn);
		}
		else if(httpStatus == Response.Status.SERVICE_UNAVAILABLE.getStatusCode())
		{
			// 503 XDS_REGISTRY_NOT_AVAILABLE
			throw new DasException("XDSRegistryNotAvailable", icn);
		}
		else if(httpStatus == Response.Status.GATEWAY_TIMEOUT.getStatusCode())
		{
			// 504 XDS_REGISTRY_BUSY
			throw new DasException("XDSRegistryBusy", icn);
		}
		else if(httpStatus == Response.Status.CREATED.getStatusCode())
		{
			// 200
			// success - Read and Delete
		}
		else if(httpStatus == Response.Status.OK.getStatusCode())
		{
			// 201
			// success - Create and Update
		}
		else if(httpStatus == Response.Status.NO_CONTENT.getStatusCode())
		{
			// 204
			// success - query returning no data
		}
		else
		{
			// unexpected error from DAS
			throw new DasException("UknownError", icn);
		}

		String docId = getDocId("Doc_" + icn);

		DasOperationSendImmunizationDataResponse res = new DasOperationSendImmunizationDataResponse();
		res.setDocId(docId);

		return res;
	}

	private String getDocId(String response)
	{
		return response;
	}

	public DasOperationSendACPDocumentResponse doOperationSendACPDocument(DasOperationSendACPDocumentRequest request) throws DasException
	{
		throw new DasException("Not supported yet.");
	}
}
