/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.utils.collections;

import java.util.*;

/**
 *
 * @author DNS   VAZQUD
 */
public class BoundedArrayList<T> extends ArrayList<T>
{
    private long maxCapacity;
    
    public BoundedArrayList()
    {
        this(500);
    }
    
    public BoundedArrayList(int maxCapacity)
    {
        this.maxCapacity = maxCapacity;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c)
    {
        checkCapacity(c.size());
        return super.addAll(index, c); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public boolean addAll(Collection<? extends T> c)
    {
        checkCapacity(c.size());
        return super.addAll(c); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public void add(int index, T element)
    {
        checkCapacity(1);
        super.add(index, element); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public boolean add(T e)
    {
        checkCapacity(1);
        return super.add(e); //To change body of generated methods, choose Tools | Templates.
    }
    
    private void checkCapacity(int size)
    {
        if (size() + size > maxCapacity) {
            throw new RuntimeException("Cannot add item(s) to list because max capacity of list has been reached.");
        }
    }
}
