/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.logging;

import gov.hhs.fha.nhinc.common.nhinccommon.AssertionType;
import gov.va.med.nhin.adapter.logging.LogConstants.AuditingEvent;
import javax.xml.ws.handler.soap.SOAPMessageContext;

/**
 * Factory for creating and logging audit events. Usually, the methods using
 * {@link AuditingEvent} are all you need. However, if you need to modify the
 * event prior to logging, use
 * {@link #newEvent(gov.va.med.nhin.adapter.logging.LogConstants.AuditingEvent)}
 * followed by {@link #debug(java.lang.Object) }
 *
 * @author ryan
 * @param <T> Type of auditing class this factory uses
 */
public interface EventAuditingFactory<T> {

  public void trace(AuditingEvent c, Class<?> klass);

  public void debug(AuditingEvent c, Class<?> klass);

  public void info(AuditingEvent c, Class<?> klass);

  public void warn(AuditingEvent c, Class<?> klass);

  public void error(AuditingEvent c, Class<?> klass);

  /**
   * Creates an {@link AuditingEvent#INFO} event from the given SOAP request. In
   * particular, it sets
   * {@link LogConstants#ENDPOINT}, {@link LogConstants#LOCAL_ADDR}, and
   * {@link LogConstants#REMOTE_ADDR}
   *
   * @param context
   * @param source the caller's class
   * @return
   */
  public T newEvent(SOAPMessageContext context, Class<?> source);

  /**
   * Creates a new event of the given type with the information available in the
   * AssertionType
   *
   * @param info the assertion information
   * @param c the type of event to log
   * @param source the caller's class
   * @return
   */
  public T newEvent(AssertionType info, AuditingEvent c, Class<?> source);

  /**
   * A convenience function to {@link #newEvent(gov.va.med.nhin.adapter.logging.LogConstants.AuditingEvent, boolean, java.lang.Class)
   * newEvent( event, TRUE, class)}
   *
   * @param c the type of event to log
   * @param source the caller's class
   * @return
   */
  public T newEvent(AuditingEvent c, Class<?> source);

  /**
   * Creates a new event of the given type for auditing,
   *
   * @param c the type of event to log
   * @param includeNetworkIfAvail if true, include any networking data that is
   * stored in the MDC. Network variables in the MDC are
   * {@link LogConstants#ENDPOINT}, {@link LogConstants#LOCAL_ADDR}, and
   * {@link LogConstants#REMOTE_ADDR}
   * @param source the caller's class
   * @return
   */
  public T newEvent(AuditingEvent c, boolean includeNetworkIfAvail,
          Class<?> source);

  public void trace(T event);

  public void debug(T event);

  public void info(T event);

  public void warn(T event);

  public void error(T event);

  /**
   * Adds an agent to the given event
   *
   * @param event the event to change
   * @param systemuri the URI of the agent
   * @param rolename the role of the agent, related to the URI
   * @param name the name of the agent
   * @return the event
   */
  public T addAgent(T event, String systemuri, String rolename, String name);

  /**
   * Adds an entity to the given event
   *
   * @param event the event to change
   * @param systemuri the URI of the entity
   * @param codename the entity type, related to the URI
   * @param name the name of the entity
   * @return the event
   */
  public T addEntity(T event, String systemuri, String codename, String name);

  public MessagingHelper<T> messaging();
}
