package gov.va.med.nhin.adapter.datamanager.translators;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;

public class YesNoDataTranslator implements DataTranslator<String>
{
	@Override
	public String translate(Object input, Object result, Reference translation, DataQuery dataQuery)
	{
		String ret = null;
		String yesValue = translation.getProperty("yesValue");

		// Anything that doesn't satisfy the YES condition will return "NO"
		// Code structure is to allow for easy modification for different
		// failure function
		try
		{
			if(input != null && input instanceof String)
			{
				if(((String) input).equals(yesValue))
				{
					ret = "YES";
				}
				else if(((String) input).equals(yesValue)) // RPB - how could we get here?
				{
					ret = "NO";
				}
				else
				{
					ret = "NO";
				}
			}
			else
			{
				ret = "NO";
			}
		}
		catch(Throwable t)
		{
			throw new DataManagerException("There was an error.", t);
		}

		return ret;
	}
}
