package gov.va.med.nhin.adapter.datamanager.translators;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.utils.NullChecker;

/**
 *
 * @author Jay Ward
 */
public class IfDataTranslator implements DataTranslator<Object> {

    @Override
    public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery) {
        Object ret = null;
        String statement = translation.getProperty("statement");
        String ifTrue = translation.getProperty("ifTrue");
        String ifFalse = translation.getProperty("ifFalse");

        if (evaluateStatement(statement, translation)) {
            ret = (ifTrue.equals("$input") ? input : translation.getSpecial(ifTrue));
        } else {
            ret = (ifFalse.equals("$input") ? input : translation.getSpecial(ifFalse));
        }

        return (ret != null ? ret : "");
    }

    private boolean evaluateStatement(String statement, Reference translation) {
        if (NullChecker.isNullOrEmpty(statement)) {
            return false;
        }
        Object[] bits = statement.split("\\s+");
        boolean not = false;
        for(int i = 0;i < bits.length;i++) {
            if(((String)bits[i]).matches("^!?")) {
                not = true;
                bits[i] = ((String)bits[i]).substring(1);
            }
            if(((String)bits[i]).matches("[\\$#\\w\\.]+")) {
                bits[i] = translation.getSpecial((String)bits[i]);
                continue;
            }
        }
        return evaluateStatement(not, bits);
    }
    
    private boolean evaluateStatement(boolean not, Object[] statement) {
        boolean curValue = true;
        Object leftSide = null;
        String comparison = "";
        for(Object bit: statement) {
            if(bit instanceof String) {
                if(((String) bit).matches("[\\!\\=\\>\\<\\&|]+")) {
                    comparison = (String) bit;
                    continue;
                }
            }
            if(leftSide == null) { 
                leftSide = bit; 
                continue;
            }
            curValue &= evaluate(leftSide, comparison, bit);
        }
        return (not ? !curValue : curValue);
    }
    
    private boolean evaluate(Object leftSide, String comparison, Object rightSide) {
        switch(comparison) {
            case "": 
                return NullChecker.isNotNullOrEmpty(leftSide);
            case "=":
            case "==":
                if(NullChecker.isNullOrEmpty(leftSide) && NullChecker.isNullOrEmpty(rightSide)) { return true; }
                if(NullChecker.isNullOrEmpty(leftSide) || NullChecker.isNullOrEmpty(rightSide)) { return false; }
                return leftSide.equals(rightSide);
            case "&":
            case "&&":
                return booleanValue(leftSide) && booleanValue(rightSide);
            case "|":
            case "||":
                return booleanValue(leftSide) || booleanValue(rightSide);
        }
        if(!(leftSide instanceof Comparable)) {
            throw new DataManagerException(leftSide.toString()+" is not Comparable");
        }
        if(!(rightSide instanceof Comparable)) {
            throw new DataManagerException(rightSide.toString()+" is not Comparable");
        }
        int i = ((Comparable)leftSide).compareTo(((Comparable)rightSide));
        switch(comparison) {
            case ">=":
                return i >= 0;
            case ">":
                return i > 0;
            case "<=":
                return i <= 0;
            case "<":
                return i < 0;
                
        }
        throw new DataManagerException("Not sure what "+comparison+" is or now to use it to evaluate the statement as a comparison.");
    }

    private boolean booleanValue(Object side) {
        if(side instanceof Boolean) { return (Boolean)side; }
        return NullChecker.isNotNullOrEmpty(side);
    }
}
