package gov.va.med.nhin.adapter.datamanager.translators;

import java.util.Date;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;

/**
 *
 * @author DNS   VAZQUD
 */
public class EarliestDateDataTranslator implements DataTranslator<Date>
{
	@Override
	public Date translate(Object input, Object result, Reference translation, DataQuery dataQuery)
	{
		Date ret = null;
		String propertyNames = translation.getProperty("propertyNames");

		for(String propertyName : propertyNames.split(","))
		{
			try
			{
				Object value = translation.getValue(propertyName);
				if(value != null)
				{
					Date dateValue = (Date) value;
					if(ret == null || dateValue.before(ret))
					{
						ret = dateValue;
					}
				}
			}
			catch(ClassCastException cce)
			{
				throw new DataManagerException("Only properties of type java.util.Date are supported.");
			}
		}

		return ret;
	}
}
