package gov.va.med.nhin.adapter.datamanager.translators;

import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.utils.NullChecker;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

/**
 *
 * @author David Vazquez
 */
public class DateFileManDataTranslator implements DataTranslator<String>
{
	static private final String FILEMAN_DATE_PATTERN = "yyyyMMdd.HHmmss";

	@Override
	public String translate(Object input, Object result, Reference translation, DataQuery dataQuery)
	{
		String ret = null;
		String targetDateFormat = translation.getProperty("targetDateFormat");
		String trim = translation.getProperty("trim");

		if(input != null)
		{
			if(!(input instanceof Date))
			{
				throw new RuntimeException("input must be of type java.util.Date.");
			}

			if(!NullChecker.isNullOrEmpty(targetDateFormat))
			{
				if(!FILEMAN_DATE_PATTERN.startsWith(targetDateFormat))
				{
					throw new RuntimeException("targetDateFormat is invalid.");
				}
			}
			else
			{
				targetDateFormat = FILEMAN_DATE_PATTERN;
			}

			Date d = (Date) input;
			Calendar cal = GregorianCalendar.getInstance();
			cal.setTime(d);
			cal.add(Calendar.YEAR, -1700);

			SimpleDateFormat formatter = new SimpleDateFormat(targetDateFormat);
			ret = formatter.format(cal.getTime());
			if(trim != null)
			{
				ret = ret.replaceFirst("^0*", "");
			}
		}

		return ret;
	}
}
