package gov.va.med.nhin.adapter.datamanager.translators;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.utils.NullChecker;

/**
 *
 * @author David Vazquez
 */
public class DateAddDataTranslator implements DataTranslator<Date>
{
	@Override
	public Date translate(Object input, Object result, Reference translation, DataQuery dataQuery)
	{
		Date ret = null;
		String value = translation.getProperty("value");
		String field = translation.getProperty("field");

		if(input != null)
		{
			if(!(input instanceof Date))
			{
				throw new RuntimeException("input must be of type java.util.Date");
			}

			if(NullChecker.isNullOrEmpty(field) || !(field.equals("MONTH") || field.equals("DAY") || field.equals("YEAR")))
			{
				throw new RuntimeException("field property must be one of DAY, MONTH, or YEAR.");
			}

			int f = 0;
			switch ( field ) {
				case "DAY":
					f = Calendar.DAY_OF_YEAR;
					break;
				case "MONTH":
					f = Calendar.MONTH;
					break;
				case "YEAR":
					f = Calendar.YEAR;
					break;
				default:
					break;
			}

			int v = Integer.parseInt(value);

			Calendar cal = GregorianCalendar.getInstance();
			cal.setTime((Date) input);
			cal.add(f, v);
			ret = cal.getTime();
		}

		return ret;
	}
}
