package gov.va.med.nhin.adapter.datamanager.translators;

import java.io.ByteArrayOutputStream;

import javax.xml.XMLConstants;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;

/**
 *
 * @author David Vazquez
 */
public class DOMToByteArrayDataTranslator implements DataTranslator<byte[]>
{
		@Override
    public byte[] translate(Object input, Object result, Reference translation, DataQuery dataQuery)
    {
        byte[] ret = null;

        if (input != null) {
            if (!(input instanceof Document)) {
                throw new DataManagerException("input must be of type org.w3c.dom.Document.");
            }

            Source source = new DOMSource((Document) input);

            ByteArrayOutputStream output = new ByteArrayOutputStream();
            Result rslt = new StreamResult(output);

            try {
                TransformerFactory transFact = TransformerFactory.newInstance();
                transFact.setFeature(XMLConstants.FEATURE_SECURE_PROCESSING, true);
                transFact.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD"/*XMLConstants.ACCESS_EXTERNAL_DTD*/, "");
                transFact.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet"/*XMLConstants.ACCESS_EXTERNAL_STYLESHEET*/, "");
                Transformer trans = transFact.newTransformer();
                trans.transform(source, rslt);
                ret = output.toByteArray();
            } catch (TransformerException te) {
                throw new DataManagerException("An error occurred translating DOM to byte array.", te);
            }
        }

        return ret;
    }
}
