package gov.va.med.nhin.adapter.datamanager.translators;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.datamanager.SmartHashMap;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * @author vhaiswchmarc
 *
 * Performs all the additional filtering based on the AdditionalParameters
 * passed.
 *
 */
public class CreateSectionFromList implements DataTranslator
{
    @SuppressWarnings({"unchecked", "rawtypes"})
    @Override
    public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
    {
        String sectionFromName = (String)translation.getProperty("sectionFrom");
        String listFromName = (String)translation.getProperty("listFrom");
        String sectionToName = (String)translation.getProperty("sectionTo");
        String sectionLimitStr = (String)translation.getProperty("sectionLimit");
        Integer sectionLimit = null;

        if (StringUtils.isBlank(sectionToName) || StringUtils.isBlank(listFromName) || StringUtils.isBlank(sectionFromName)) {
            throw new DataManagerException("sectionTo,  listFrom and sectionFrom property must be set.");
        }

        if (!(input instanceof SmartHashMap
              || input instanceof ArrayList && ((ArrayList)input).size() == 1 && ((ArrayList)input).get(0) instanceof SmartHashMap)) {
            throw new DataManagerException("input must be a Map or an Array with one SmartHashMap entry in it.");
        }

        if (sectionLimitStr != null && sectionLimitStr.length() > 0) {
            sectionLimit = new Integer(sectionLimitStr);
        }

        // If input is a list with one SmartHashMap element, use that as the rootMap.
        SmartHashMap rootMap;
        if (input instanceof ArrayList && ((ArrayList)input).size() == 1 && ((ArrayList)input).get(0) instanceof SmartHashMap) {
            rootMap = (SmartHashMap)((ArrayList)input).get(0);
        }
        else {
            rootMap = (SmartHashMap)input;
        }

        List<SmartHashMap> fromSection = (List<SmartHashMap>)rootMap.get(sectionFromName);

        List<SmartHashMap> toSection = new ArrayList<>();
        rootMap.put(sectionToName, toSection);

        if (CollectionUtils.isNotEmpty(fromSection)) {
            int limit = sectionLimit != null ? Math.min(sectionLimit, fromSection.size()) : fromSection.size();
            for (int i = 0; i < limit; ++i) {
                SmartHashMap map = fromSection.get(i);
                Object fromObj = map.get(listFromName);
                if (fromObj != null) {
                    if (fromObj instanceof List) {
                        toSection.addAll((List)fromObj);
                    }
                    else {
                        toSection.add((SmartHashMap)fromObj);
                    }
                }
            }
        }

        return input;
    }
}
