/**
 * 
 */
package gov.va.med.nhin.adapter.datamanager.translators;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.datamanager.SmartHashMap;
import org.slf4j.LoggerFactory;

/**
 * @author vhaiswchmarc
 *
 *         Class will copy items from one section to another, that match passed
 *         in key values. This overcomes limitations in the mapping files when
 *         additional data is needed.
 * 
 *         This will add all data that does not currently exist to the "to"
 *         object.
 * 
 *         This does everything in place.
 *
 */
public class CombineDataOnKeyTranslator implements DataTranslator {

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.nhin.adapter.datamanager.DataTranslator#translate(java.lang
	 * .Object, java.lang.Object, gov.va.med.nhin.adapter.datamanager.Reference,
	 * gov.va.med.nhin.adapter.datamanager.DataQuery)
	 */
	// @SuppressWarnings({ "unchecked", "rawtypes" })
	@Override
	public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery) {
		// The location of the list elements to overwrite with. Must be in the
		// Root.
		String fromName = translation.getProperty("fromData");
		// The identifier to use as a match
		String fromKey = translation.getProperty("fromKey");
		// The List that has the data to overwrite. Can only be up to one level
		// deep.
		String toSectionName = translation.getProperty("toSection");
		// The list that needs updating.
		String toObjectName = translation.getProperty("toObject");
		// The Identifier to use for comparison.
		String toKey = translation.getProperty("toKey");

		if (StringUtils.isBlank(fromName) || StringUtils.isBlank(toSectionName) || StringUtils.isBlank(toObjectName) || StringUtils.isBlank(fromKey) || StringUtils.isBlank(toKey)) {
			throw new DataManagerException("fromData, fromKey, toSection, toObject and toKey  properties must be set.");
		}

		try {
			Object fromData = PropertyUtils.getProperty(input, fromName);
			Object toSection = PropertyUtils.getProperty(input, toSectionName);

			if (fromData != null && toSection != null) {
				if ((fromData instanceof List) && (toSection instanceof List)) {
					List<SmartHashMap> fromList = (List<SmartHashMap>) fromData;
					List<SmartHashMap> sectionList = (List<SmartHashMap>) toSection;

					for (SmartHashMap sectionObj : sectionList) {
						Object toObj = PropertyUtils.getProperty(sectionObj, toObjectName);
						if (toObj instanceof List) {
							List<SmartHashMap> toList = (List<SmartHashMap>) toObj;
							for (SmartHashMap to : toList) {
								for (SmartHashMap from : fromList) {
									if (from.containsKey(fromKey) && to.containsKey(toKey)) {
										if (from.get(fromKey).equals(to.get(toKey))) {
											for (Map.Entry<String, Object> entry : from.entrySet()) {
													String key = entry.getKey();
													Object value = entry.getValue();
													if (!to.containsKey(key)) {
														to.put(key, value);
													}
											}
										}
									}
								}
							}
						}
					}
				} else {
					throw new DataManagerException("fromData and toData both have to be lists, and they are not.");
				}
			}
		} catch (IllegalAccessException | InvocationTargetException | NoSuchMethodException e) {
			// TODO Auto-generated catch block
			LoggerFactory.getLogger( getClass() ).error(  "error translating", e );
		}

		return input;
	}
}
