package gov.va.med.nhin.adapter.datamanager.parsers;

import java.io.StringBufferInputStream;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.beanutils.PropertyUtils;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataParser;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.utils.NullChecker;
import gov.va.med.nhin.adapter.utils.Utils;
import gov.va.med.nhin.adapter.utils.XMLUtils;
import java.io.ByteArrayInputStream;

/**
 *
 * @author David Vazquez
 */
public class JAXBDataParser implements DataParser
{
	public List parse(List dataResults, Reference parser, DataQuery dataQuery)
	{
		List ret;
		String className = parser.getProperty("className");
		String returnProperty = parser.getProperty("returnProperty");
		String results = (String) dataResults.get(0);

		Class cls;
		try
		{
			cls = Class.forName(className);
		}
		catch(Throwable t)
		{
			throw new DataManagerException("Unable to find class, " + className + ".", t);
		}

		Object result;
		try
		{
			ByteArrayInputStream bais = new ByteArrayInputStream( results.getBytes( "UTF-8" ) );
			result = XMLUtils.load( bais, cls);
		}
		catch(Throwable t)
		{
			throw new DataManagerException("Unable to unmarshal results.", t);
		}

		if(!NullChecker.isNullOrEmpty(returnProperty))
		{
			Object obj;
			try
			{
				obj = PropertyUtils.getProperty(result, returnProperty);
			}
			catch(Throwable t)
			{
				throw new DataManagerException("Error getting returnProperty from unmarshalled xml object.", t);
			}

			if(!Utils.isCollection(obj))
			{
				throw new DataManagerException("Object returned by returnProperty must be a collection.");
			}

			ret = (List) obj;
		}
		else
		{
			ret = new ArrayList();
			ret.add(result);
		}

		return ret;
	}
}
