package gov.va.med.nhin.adapter.datamanager.filters;

import java.util.Date;
import java.util.List;

import org.apache.commons.beanutils.PropertyUtils;

import gov.va.med.nhin.adapter.datamanager.DataFilter;
import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.utils.NullChecker;

/**
 *
 * @author David Vazquez
 */
public class MostRecentDateDataFilter implements DataFilter
{
	public boolean test(Object result, List results, Reference filterType, DataQuery dataQuery)
	{
		boolean ret = true;

		try
		{
			if(!results.isEmpty())
			{
				String fieldNames = filterType.getProperty("fieldNames");
				String[] fieldNamesArray = fieldNames.split(",");

				int newTestPosition = getTestPosition(fieldNamesArray, result);
				Date newValue = (Date) getTestValue(result, fieldNamesArray, newTestPosition);

				for(Object curResult : results)
				{
					int curTestPosition = getTestPosition(fieldNamesArray, curResult);
					Date curValue = (Date) getTestValue(curResult, fieldNamesArray, curTestPosition);

					ret &= (newTestPosition < curTestPosition || (newTestPosition == curTestPosition && (newTestPosition == Integer.MAX_VALUE || newValue.after(curValue))));
					if(!ret)
						break;
				}
			}
		}
		catch(Exception e)
		{
			throw new DataManagerException("An error occurred processing filter.", e);
		}

		return ret;
	}

	private int getTestPosition(String[] fieldNamesArray, Object result)
	{
		int ret = Integer.MAX_VALUE;

		for(int i = 0; i < fieldNamesArray.length; ++i)
		{
			try
			{
				Object value = PropertyUtils.getProperty(result, fieldNamesArray[i]);
				if(!NullChecker.isNullOrEmpty(value))
				{
					ret = i;
					break;
				}
			}
			catch(Exception e)
			{
				throw new DataManagerException("An error occurred processing filter.", e);
			}
		}

		return ret;
	}

	private Object getTestValue(Object result, String[] fieldNamesArray, int position) throws Exception
	{
		Object ret = null;

		if(position < fieldNamesArray.length)
		{
			ret = PropertyUtils.getProperty(result, fieldNamesArray[position]);
		}

		return ret;
	}
}
