package gov.va.med.nhin.adapter.datamanager.adapters;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.med.nhin.adapter.datamanager.DataAdapter;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.QueryDoesNotExistException;
import gov.va.med.nhin.adapter.utils.NullChecker;

/**
 *
 * @author DNS   VAZQUD
 */
public class QueryAggregatorDataAdapter implements DataAdapter
{
	private static final Logger logger = LoggerFactory.getLogger(QueryAggregatorDataAdapter.class.getName());

	@Override
	public List getData(DataQuery dataQuery)
	{
		ArrayList ret = new ArrayList();
		String[] queryNames = getQueryNames(dataQuery);

		if(queryNames != null)
		{
			for(String queryName : queryNames)
			{
				try
				{
					DataQuery query = setUpQuery(dataQuery, queryName);
					ret.addAll(query.getResults());
				}
				catch(QueryDoesNotExistException qdnee)
				{
					logger.error("Query is not supported.", qdnee);
				}
			}
		}

		return ret;
	}

	private String[] getQueryNames(DataQuery dataQuery)
	{
		String queryNames = (String) dataQuery.getParameter("queryNames");
		
		if(NullChecker.isNullOrEmpty(queryNames))
		{
			queryNames = dataQuery.getProperty("queryNames");
		}
		
		return NullChecker.isNotNullOrEmpty(queryNames) ? queryNames.split(",") : null;
	}

	private DataQuery setUpQuery(DataQuery dataQuery, String queryName)
	{
		DataQuery ret = dataQuery.getDataManager().getQuery(queryName);
		for(String parameterName : dataQuery.getParameterBySourceNames())
		{
			if(ret.isParameter(parameterName))
			{
				ret.setParameter(parameterName, dataQuery.getParameterBySource(parameterName));
			}
		}
		return ret;
	}
}
