package gov.va.med.nhin.adapter.datamanager.adapters;

import java.util.List;

import gov.va.med.nhin.adapter.datamanager.DataAdapter;
import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.utils.NullChecker;
import gov.va.med.nhin.adapter.utils.config.PropertiesType;
import gov.va.med.nhin.adapter.utils.config.PropertyType;

/**
 *
 * @author David Vazquez
 */
public class PassThroughDataAdapter implements DataAdapter
{
	@Override
	public List getData(DataQuery dataQuery)
	{
		String queryName = dataQuery.getProperty("queryName");

		if(NullChecker.isNullOrEmpty(queryName))
		{
			throw new DataManagerException("queryName must be specified.");
		}

		DataQuery subQuery = dataQuery.getDataManager().getQuery(queryName);

		for(String parameterName : dataQuery.getParameterBySourceNames())
		{
			if(subQuery.isParameter(parameterName))
			{
				subQuery.setParameter(parameterName, dataQuery.getParameterBySource(parameterName));
			}
		}
                
                PropertiesType setProperties = dataQuery.getProperties(queryName + ".setProperties");
                if (setProperties != null) {
                    for (PropertyType setProperty : setProperties.getProperty()) {
                        subQuery.setProperty(setProperty.getName(), dataQuery.getParameter(setProperty.getValue()).toString());
                    }
                }

		return subQuery.getResults();
	}
}
