/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.med.nhin.adapter.datamanager;


import org.apache.commons.beanutils.*;

import gov.va.med.nhin.adapter.datamanager.config.*;
import gov.va.med.nhin.adapter.utils.*;
import gov.va.med.nhin.adapter.utils.config.*;

/**
 *
 * @author David Vazquez
 * @param <T>
 */
public class Reference<T>
{
    private final ReferenceType reference;
    private final DeclarationType declaration;
    private final T obj;
    private final Object result;
    private final Object sourceResult;
    
    public Reference(ReferenceType reference, DeclarationType declaration, T obj)
    {
        this.reference = reference;
        this.declaration = declaration;
        this.obj = obj;
        this.result = this.sourceResult = null;
    }

    public Reference(ReferenceType reference, DeclarationType declaration, T obj, Object result, Object sourceResult)
    {
        this.reference = reference;
        this.declaration = declaration;
        this.obj = obj;
        this.result = result;
        this.sourceResult = sourceResult;
    }

    public DeclarationType getDeclaration()
    {
        return declaration;
    }

    public ReferenceType getReference()
    {
        return reference;
    }

    public String getProperty(String name)
    {
        String ret = (String) getSpecial(name);
        if(ret != null) { return ret; };

        if (reference != null) {
            ret = PropertyTypeUtils.getProperty(reference.getProperties(), name);
        }

        if (NullChecker.isNullOrEmpty(ret)) {
            if (declaration != null) {
                ret = PropertyTypeUtils.getProperty(declaration.getProperties(), name);
            }
        }

        return ret;
    }

    public Integer getPropertyAsInteger(String name)
    {
        Integer ret = null;
        
        if (reference != null) {
            ret = PropertyTypeUtils.getPropertyAsInteger(reference.getProperties(), name);
        }
        
        if (NullChecker.isNullOrEmpty(ret)) {
            if (declaration != null) {
                ret = PropertyTypeUtils.getPropertyAsInteger(declaration.getProperties(), name);
            }
        }
        
        return ret;
    }
    
    public PropertiesType getProperties(String name)
    {
        PropertiesType ret = null;

        if (reference != null) {
            ret = PropertyTypeUtils.getProperties(reference.getProperties(), name);
        }

        if (NullChecker.isNullOrEmpty(ret)) {
            if (declaration != null) {
                ret = PropertyTypeUtils.getProperties(declaration.getProperties(), name);
            }
        }

        return ret;
    }

    public T getObj()
    {
        return obj;
    }
    
    public Object getSpecial(String name) {
        if(name.length() > 1 && name.substring(0, 1).equals("#")) {
            return getProperty(name.substring(1));
        }
        if(name.length() > 1 && name.substring(0, 1).equals("$")) {
            return getValue(name.substring(1));
        }
        return null;
    }

    public Object getValue(String property)
    {
        Object ret = getSpecial(property);
        if(ret != null) { return ret; }
        
        ret = getProperty(result, property);
        if (ret == null){
            ret = getProperty(sourceResult, property);
        }

        return ret;
    }

    private Object getProperty(Object bean, String property)
    {
        Object ret;

        try {
            ret = PropertyUtils.getProperty(bean, property);
        }
        catch (Throwable t) {
            ret = null;
        }

        return ret;
    }
}
