/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.med.nhin.adapter.datamanager;

import java.util.*;

/**
 *
 * @author David Vazquez
 */
public class DataManagerFactory
{
    static private final HashMap<String, DataManagerImpl> dataManagerCache = new HashMap<String, DataManagerImpl>();

    static public synchronized DataManagerImpl getDataManager(String ID, String configFilename)
        throws DataManagerException
    {
        DataManagerImpl ret = dataManagerCache.get(ID);
        if (ret == null) {
            ret = new DataManagerImpl(configFilename);
            dataManagerCache.put(ID, ret);
        }

        return ret;
    }
}
