/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.datamanager;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author David Vazquez
 * @param <T> type of bean
 */
public class BeanDataProxy<T> implements DataProxy<T>
{
    static private final Logger logger = LoggerFactory.getLogger(BeanDataProxy.class.getName());
    
    private T bean;

    @Override
    public void setObject(T bean)
    {
        this.bean = bean;
    }

    @Override
    public T getObject()
    {
        return bean;
    }

    @Override
    public Object get(String property)
    {
        Object ret = null;

        try {
            ret = PropertyUtils.getProperty(bean, property);
        }
        catch (NestedNullException nne) {
            logger.debug("Unable to get property " + property + " from bean of type " + bean.getClass().getName() + " because object in which it is nested is not set. This might be normal, but review configuration to be sure. Returning null.");
            ret = null;
        }
        catch (NoSuchMethodException | IllegalArgumentException nme) {
            logger.debug("Unable to get property " + property + " from bean of type " + bean.getClass().getName() + " because method does not exist. Configuration should be reviewed. Returning null.", nme);
            ret = null;
        }
        catch (IllegalAccessException | InvocationTargetException t) {
            throw new DataManagerException("Unable to get property " + property + " from bean of type " + bean.getClass().getName(), t);
        }

        return ret;
    }

    @Override
    public void set(String property, Object value)
    {
        try {
            PropertyUtils.setProperty(bean, property, value);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException t) {
            throw new DataManagerException("Unable to set property " + property + " on bean of type " + bean.getClass().getName(), t);
        }
    }
}
