/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.policyengine;

import gov.va.med.nhin.adapter.adaptergateway.TestUtils;
import java.io.File;
import oasis.names.tc.xacml._2_0.context.schema.os.RequestType;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author ryan
 */
public class CheckPolicyRequestBuilderTest {

	private static final File TESTDIR = new File( "src/test/resources" );

	@BeforeClass
	public static void setUpClass() {
	}

	@AfterClass
	public static void tearDownClass() {
	}

	@Before
	public void setUp() {
	}

	@After
	public void tearDown() {
	}

	@Test
	public void testBuildNHINOutCheckPolicyRequest() throws Exception {
		String userId = "uuuuuuserid";
		String subjectHomeCommunityId = "home comm id";
		RequestType result = CheckPolicyRequestBuilder.buildNHINOutCheckPolicyRequest(
				userId, subjectHomeCommunityId );

		TestUtils.assertResultsOk( RequestType.class, result,
				new File( TESTDIR, "nhin-out-cp.xml" ) );
	}

	@Test
	public void testBuildPatientDiscoveryOutCheckPolicyRequest() throws Exception {
		String userId = "uuuuuuserid";
		String subjectHomeCommunityId = "home comm id";
		String patientId = "frankenstein-01";
		String purposeForUse = "Pee-yew, POU";
		String homeCommunityId = "hc";

		RequestType result = CheckPolicyRequestBuilder.buildPatientDiscoveryOutCheckPolicyRequest(
				userId, patientId, purposeForUse, homeCommunityId, subjectHomeCommunityId );
		TestUtils.assertResultsOk( RequestType.class, result,
				new File( TESTDIR, "nhin-disc-out-cp.xml" ) );
	}

	@Test
	public void testBuildDocumentQueryOutCheckPolicyRequest() throws Exception {
		String userId = "uuuuuuserid";
		String subjectHomeCommunityId = "home comm id";
		String patientId = "frankenstein-01";
		String purposeForUse = "Pee-yew, POU";
		String homeCommunityId = "hc";
		RequestType result = CheckPolicyRequestBuilder.buildDocumentQueryOutCheckPolicyRequest(
				userId, patientId, purposeForUse, homeCommunityId, subjectHomeCommunityId );

		TestUtils.assertResultsOk( RequestType.class, result,
				new File( TESTDIR, "nhin-q-out-cp.xml" ) );
	}

}
