/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.docquery;

import gov.hhs.fha.nhinc.adapterdocquery.AdapterDocQueryPortType;
import gov.hhs.fha.nhinc.adapterpolicyengine.AdapterPolicyEnginePortType;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.CheckPolicyResponseType;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.RespondingGatewayCrossGatewayQueryRequestType;
import gov.va.med.nhin.adapter.adaptergateway.FakeTestingAdapterPolicyEngine;
import gov.va.med.nhin.adapter.adaptergateway.TestUtils;
import gov.va.med.nhin.adapter.errors.CreateErrorInterface;
import gov.va.med.nhin.adapter.facilitymanager.Facility;
import gov.va.med.nhin.adapter.facilitymanager.FacilityManager;
import gov.va.med.nhin.adapter.facilitymanager.OperationOnOff;
import gov.va.med.nhin.adapter.sensitiveInfo.SensitiveInfoManager;
import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryResponse;
import oasis.names.tc.xacml._2_0.context.schema.os.DecisionType;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 *
 * @author alok.subedi
 */
public class AdapterDocQueryTest {
    
    private static final String TEST_DIR = "src/test/resources";
    private static final File REQUEST = new File(TEST_DIR, "adapter_docquery_request.xml");
    private static final File RESPONSE = new File(TEST_DIR, "adapter_docquery_response.xml");
    
    private Mockery context;
    private AdapterDocQuery instance;
    
    public AdapterDocQueryTest() {
    }
    
    @BeforeClass
    public static void setUpClass() {
        System.setProperty("javax.xml.parsers.SAXParserFactory",
                "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
    }
    
    @AfterClass
    public static void tearDownClass() {
    }
    
    @Before
    public void setUp() {
        this.context = new JUnit4Mockery();
        this.instance = new AdapterDocQuery();
    }
    
    @After
    public void tearDown() {
    }

    /**
     * Test of respondingGatewayCrossGatewayQuery method, of class AdapterDocQuery.
     */
    @Test
    public void testRespondingGatewayCrossGatewayQuery() throws Exception {
        JAXBContext jaxb = JAXBContext.newInstance(RespondingGatewayCrossGatewayQueryRequestType.class, AdhocQueryResponse.class);
        Unmarshaller unm = jaxb.createUnmarshaller();
        
        RespondingGatewayCrossGatewayQueryRequestType request = TestUtils.fileToPojo(REQUEST, RespondingGatewayCrossGatewayQueryRequestType.class, unm);
        final AdhocQueryResponse response = TestUtils.fileToPojo(RESPONSE, AdhocQueryResponse.class, unm);
        
        final AdapterDocQueryPortType docQuery = context.mock(AdapterDocQueryPortType.class);
        final AdapterPolicyEnginePortType policyEngine = new FakeTestingAdapterPolicyEngine(DecisionType.PERMIT);
        //context.mock(AdapterPolicyEnginePortType.class);
        final FacilityManager facilityManager = context.mock(FacilityManager.class);
        final CreateErrorInterface errorResponse = context.mock(CreateErrorInterface.class);
        final SensitiveInfoManager sensitiveInfoBean = context.mock(SensitiveInfoManager.class);
        instance.setDocQuery(docQuery);
        instance.setErrorResponse(errorResponse);
        instance.setFacilityManager(facilityManager);
        instance.setPolicyEngine(policyEngine);
        instance.setSensitiveInfoBean(sensitiveInfoBean);
        
        final String partnerCommunityId = "urn:oid:2.16.840.1.113883.3.184.6.1";

				final Facility facility = new Facility();
				facility.setFacilityNumber( "VA" );
				facility.setHomeCommunityId( "1.1" );
				facility.setFullHomeCommunityId( "1.1" );

        
        context.checking(new Expectations(){
					{
						allowing(facilityManager).isPartnerAllowed(partnerCommunityId, OperationOnOff.ONBOARD);
						will(returnValue(true));
						allowing(facilityManager).isPartnerAllowed(partnerCommunityId, OperationOnOff.IN_DQ);
						will(returnValue(true));

						allowing( facilityManager).getFacilityByFacilityNumber( "VA");
						will (returnValue( facility ) );

						allowing(sensitiveInfoBean).checkPolicyAndAddSlot(with(any(RespondingGatewayCrossGatewayQueryRequestType.class)),
										with(any(CheckPolicyResponseType.class)));

						allowing(docQuery).respondingGatewayCrossGatewayQuery(with(any(RespondingGatewayCrossGatewayQueryRequestType.class)));
						will(returnValue(response));
					}
        });
        
        
        AdhocQueryResponse result = instance.respondingGatewayCrossGatewayQuery(request);
        TestUtils.assertResultsOk(AdhocQueryResponse.class, result,
                "//Slot[@name='hash']/ValueList/Value","df8e5cdd850237d945f36bcf11fc717f62da6c73");
        TestUtils.assertResultsOk(AdhocQueryResponse.class, result,
                "//Slot[@name='serviceStartTime']/ValueList/Value","19600303000000");
        TestUtils.assertResultsOk(AdhocQueryResponse.class, result,
                "//Slot[@name='size']/ValueList/Value","2333342");
        context.assertIsSatisfied();
    }
    
}
