/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.adapterxdr;

import gov.hhs.fha.nhinc.common.nhinccommonadapter.AdapterProvideAndRegisterDocumentSetRequestType;
import gov.hhs.fha.nhinc.nhinccomponentpatientcorrelation.PatientCorrelationPortType;
import gov.va.med.nhin.adapter.adaptergateway.TestUtils;
import gov.va.med.nhin.adapter.audit.Audit;
import gov.va.med.nhin.adapter.audit.AuditManager;
import gov.va.med.nhin.adapter.documentrepository.DocumentRepository;
import gov.va.med.nhin.adapter.facilitymanager.Facility;
import gov.va.med.nhin.adapter.facilitymanager.FacilityManager;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookup;
import gov.va.med.nhin.adapter.utils.das.DasDAO;
import gov.va.med.nhin.adapter.utils.das.DasOperationSendImmunizationDataRequest;
import gov.va.med.nhin.adapter.utils.das.DasOperationSendImmunizationDataResponse;
import gov.va.nvap.privacy.OrganizationTrustedSourceRequestType;
import gov.va.nvap.privacy.OrganizationTrustedSourceResponseType;
import ihe.iti.xds_b._2007.ProvideAndRegisterDocumentSetRequestType.Document;
import java.io.File;
import java.util.Base64;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.RegistryResponseType;
import org.apache.commons.io.FileUtils;
import org.hl7.v3.II;
import org.hl7.v3.RetrievePatientCorrelationsRequestType;
import org.hl7.v3.RetrievePatientCorrelationsResponseType;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import privacy.service.nvap.DNS   .ConsentManagementPortType;

/**
 *
 * @author alok.subedi
 */
@RunWith(JMock.class)
public class AdapterXDRTest {

    private static final String TEST_DIR = "src/test/resources";
    private static final File REQUEST_FILE = new File(TEST_DIR, "document_submission_request.xml");
    private static final File CORRELATION_RESPONSE = new File(TEST_DIR, "correlations-response.xml");
    private static final File DOCUMENT = new File(TEST_DIR, "document.txt");
    private static final File RESPONSE_FILE = new File(TEST_DIR, "document_submission_response.xml");

    private Mockery context;
    private AdapterXDR instance;

    public AdapterXDRTest() {
    }

    @Before
    public void setUp() {
        this.context = new JUnit4Mockery();
        this.instance = new AdapterXDR();
    }

    @BeforeClass
    public static void setUpClass() {
        System.setProperty("javax.xml.parsers.SAXParserFactory",
                "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
    }

    @After
    public void tearDown() {
    }

    /**
     * Test of provideAndRegisterDocumentSetb method, of class AdapterXDR.
     */
    @Test
    public void testProvideAndRegisterDocumentSetb() throws Exception {

        JAXBContext jaxb = JAXBContext.newInstance(AdapterProvideAndRegisterDocumentSetRequestType.class, RetrievePatientCorrelationsResponseType.class, Document.class);
        Unmarshaller unm = jaxb.createUnmarshaller();

        final AdapterProvideAndRegisterDocumentSetRequestType request = TestUtils.fileToPojo(REQUEST_FILE, AdapterProvideAndRegisterDocumentSetRequestType.class, unm);
        final RetrievePatientCorrelationsResponseType correlationResponse = TestUtils.fileToPojo(CORRELATION_RESPONSE, RetrievePatientCorrelationsResponseType.class, unm);

        String s = FileUtils.readFileToString(DOCUMENT);
        final byte [] document = Base64.getDecoder().decode(s);

        final String icn = "1012581676V377802";
        final String hcid = "2.16.840.1.113883.3.2018.1.5.1";
        final String fullHcid = "urn:oid:2.16.840.1.113883.3.2018.1.5.1";
        

        final PropertyLookup propertyLookup = context.mock(PropertyLookup.class);
        final FacilityManager facilityManager = context.mock(FacilityManager.class);
        final AuditManager auditManager = context.mock(AuditManager.class);
        final PatientCorrelationPortType patientCorrelationPortType = context.mock(PatientCorrelationPortType.class);
        final DocumentRepository documentRepository = context.mock(DocumentRepository.class);
        final ConsentManagementPortType consentManagementPortType = context.mock(ConsentManagementPortType.class);
        final DasDAO dasDAO = context.mock(DasDAO.class);

        final Properties props = new Properties();
        props.setProperty("vler.das.docsubmit.url", "http://MOCK-HOST:8088/ecrud/v1/core/immunizations/transform");

        PropertyLookup pl = new PropertyLookup() {
            @Override
            public String getProperty(String key) {
                return props.getProperty(key);
            }
        };

        instance.setPropertyLookup(pl);
        instance.setFacilityManager(facilityManager);
        instance.setAuditManager(auditManager);
        instance.setAdapterPatientCorrelation(patientCorrelationPortType);
        instance.setDocumentRepository(documentRepository);
        instance.setVapConsentManagement(consentManagementPortType);
        instance.setDasDAO(dasDAO);

        context.checking(new Expectations() {
            {
                II patientId = new II();
                patientId.setRoot("2.16.840.1.113883.4.349");
                patientId.setExtension(icn);

                Facility homeFacility = new Facility();
                homeFacility.setHomeCommunityId(hcid);
                homeFacility.setFacilityNumber("200NWG");
                homeFacility.setFullHomeCommunityId(fullHcid);
                
                allowing(facilityManager).getFacilityByFullHomeCommunityId(with(any(String.class)));
                will(returnValue(homeFacility));
                
                OrganizationTrustedSourceResponseType res = new OrganizationTrustedSourceResponseType();
                res.setIsTrusted(true);

                allowing(consentManagementPortType).getIsOrganizationTrustedSource(with(any(OrganizationTrustedSourceRequestType.class)));
                will(returnValue(res));
                
//                PRPAIN201310UV02 prpn = new PRPAIN201310UV02();
//                prpn.setId(patientId);
//
//                RetrievePatientCorrelationsResponseType corRes = new RetrievePatientCorrelationsResponseType();
//                corRes.setPRPAIN201310UV02(prpn);

                allowing(patientCorrelationPortType).retrievePatientCorrelations(with(any(RetrievePatientCorrelationsRequestType.class)));
                will(returnValue(correlationResponse));

                allowing(propertyLookup).getProperty("vler.das.docsubmit.url");
                will(returnValue("http://MOCK-HOST:8088/ecrud/v1/core/immunizations/transform"));

//                DasOperationSendImmunizationDataRequest req = new DasOperationSendImmunizationDataRequest();
//                req.setMessage(document);
//                req.setICN("icn");
//                req.setFacility("facilityNumber");

                DasOperationSendImmunizationDataResponse response = new DasOperationSendImmunizationDataResponse();
                response.setDocId("123");

								DasOperationSendImmunizationDataResponse drresp =
										new DasOperationSendImmunizationDataResponse();
								drresp.setDocId( "58ec59a8d943870ac8998c10");

                oneOf(dasDAO).doOperationSendImmunizationData(with(any(DasOperationSendImmunizationDataRequest.class ) ) );
                will(returnValue(drresp));

								oneOf( documentRepository ).storeDocument( with( any( gov.va.med.nhin.adapter.documentrepository.Document.class ) ) );
								oneOf( auditManager).storeAudit( with( any( Audit.class) ) );
            }
        });

        RegistryResponseType result = instance.provideAndRegisterDocumentSetb(request);
        
				TestUtils.assertResultsOk(RegistryResponseType.class, result,
						"/RegistryResponseType/ResponseSlotList/Slot[@name='DocumentId']/ValueList/Value",
						"58ec59a8d943870ac8998c10");
        context.assertIsSatisfied();
    }

}
