/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.adaptergateway;

import gov.va.med.nhin.adapter.datamanager.DataAdapter;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import static gov.va.med.nhin.adapter.adaptergateway.TestUtils.fileToString;

/**
 *
 * @author ryan
 */
public class FileBasedVistA implements DataAdapter<String> {
	private static final File RESOURCES = new File( "src/test/resources/vista-docs" );

	@Override
	public List<String> getData( DataQuery dataQuery ) throws Exception {
		List<String> list = new ArrayList<>();

		Set<String> notesDocs = new HashSet<>( Arrays.asList(
				"11488-4",
				"VistA.findConsultNotes3",
				"VistA.findHistoryAndPhysicalNotes",
				"34133-9-C" ) );

		final String queryName = dataQuery.getName();

		if ( notesDocs.contains( queryName ) ) {
			String result = fileToString( RESOURCES, "VistA.notesDocuments", ".xml" );
			list.add( result );
		}
		else if ( queryName.startsWith( "MPI." ) ) {
			String result = fileToString( RESOURCES, dataQuery.getName(), ".txt" );
			list.add( result );
		}
		else if ( queryName.startsWith( "MVI." ) ) {
			String result = fileToString( RESOURCES, dataQuery.getName(), ".xml" );
			list.add( result );
		}
		else if ( dataQuery.getName().startsWith( "ESR." ) ) {
			String result = fileToString( RESOURCES, dataQuery.getName(), ".xml" );
			list.add( result );
		}
		else if ( dataQuery.getName().startsWith( "VistA." ) ) {
			String result = fileToString( RESOURCES, dataQuery.getName(), ".xml" );
			list.add( result );
		}

		return list;

	}
}
