package gov.va.med.nhin.adapter.adaptergateway;

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/**
 *
 * @author ryan
 * @param <V>
 */
public class FakeTestingExecutorService<V> extends AbstractExecutorService {

	private final V result;
	private boolean isshut = false;

	public FakeTestingExecutorService( V resultForGet ) {
		result = resultForGet;
	}

	@Override
	protected <T> RunnableFuture<T> newTaskFor( Callable<T> callable ) {
		return new FakeFuture( (T) result );
	}

	@Override
	public void shutdown() {
		isshut = true;
	}

	@Override
	public List<Runnable> shutdownNow() {
		return new ArrayList<>();
	}

	@Override
	public boolean isShutdown() {
		return isshut;
	}

	@Override
	public boolean isTerminated() {
		return isshut;
	}

	@Override
	public boolean awaitTermination( long timeout, TimeUnit unit ) throws InterruptedException {
		return true;
	}

	@Override
	public void execute( Runnable command ) {
		command.run();
	}

	@Override
	public <T> Future<T> submit( Callable<T> task ) {
		return new FakeFuture<>( (T) result );
	}

	private class FakeFuture<T> implements RunnableFuture<T> {

		private final T value;

		public FakeFuture( T val ) {
			value = val;
		}

		@Override
		public boolean isDone() {
			return true;
		}

		@Override
		public boolean cancel( boolean mayInterruptIfRunning ) {
			return false;
		}

		@Override
		public boolean isCancelled() {
			return false;
		}

		@Override
		public T get() throws InterruptedException, ExecutionException {
			return value;
		}

		@Override
		public T get( long timeout, TimeUnit unit )
				throws InterruptedException, ExecutionException, TimeoutException {
			return value;
		}

		@Override
		public void run() {
		}
	}
}
