/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.adaptergateway;

import gov.hhs.fha.nhinc.common.nhinccommonadapter.CheckPolicyRequestType;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.CheckPolicyResponseType;
import gov.va.med.nhin.adapter.policyengine.AdapterPolicyEnginePortTypeLocal;
import oasis.names.tc.xacml._2_0.context.schema.os.DecisionType;
import oasis.names.tc.xacml._2_0.context.schema.os.ResponseType;
import oasis.names.tc.xacml._2_0.context.schema.os.ResultType;
import org.apache.log4j.Logger;

/**
 *
 * @author ryan
 */
public class FakeTestingAdapterPolicyEngine implements AdapterPolicyEnginePortTypeLocal {

	private static final Logger log = Logger.getLogger( FakeTestingAdapterPolicyEngine.class );

	private final CheckPolicyResponseType result;

	public FakeTestingAdapterPolicyEngine( DecisionType ok ) {
		result = check( ok );
	}

	public FakeTestingAdapterPolicyEngine( boolean ok ) {
		result = check( ok ? DecisionType.PERMIT : DecisionType.DENY );
	}

	@Override
	public CheckPolicyResponseType checkPolicy( CheckPolicyRequestType cprt ) {
		return result;
	}

	public static CheckPolicyResponseType check( DecisionType decision ) {
		CheckPolicyResponseType result = new CheckPolicyResponseType();
		ResponseType resp = new ResponseType();
		ResultType t = new ResultType();
		t.setDecision( decision );
		resp.getResult().add( t );
		result.setResponse( resp );
		return result;
	}

	public static CheckPolicyResponseType permit() {
		return check( DecisionType.PERMIT );
	}

	public static CheckPolicyResponseType deny() {
		return check( DecisionType.DENY );
	}
}
