<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:t="urn:hl7-org:v3"
	exclude-result-prefixes="t">

	<xsl:param name="mediaType" />
	<xsl:param name="document" />
	<xsl:param name="representation" />
	<xsl:param name="userId" />
	<xsl:param name="userFacilityNumber" />

	<xsl:template match="@* | node()">
		<xsl:copy>
			<xsl:apply-templates select="@* | node()" />
		</xsl:copy>
	</xsl:template>

	<xsl:template
		match="t:ClinicalDocument/t:component/t:structuredBody/t:component/t:section/t:entry/t:act">
		<xsl:copy>
			<xsl:apply-templates select="@* | node()" />
			<entryRelationship typeCode="COMP">
				<templateId root="2.16.840.1.113883.3.445.15" />
				<observationMedia classCode="OBS" moodCode="EVN">
					<value mediaType="{$mediaType}" representation="{$representation}">
						<xsl:value-of select="$document" />
					</value>
				</observationMedia>
			</entryRelationship>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="t:ClinicalDocument/t:assignedAuthor/t:id/@extension">
		<xsl:attribute name="extension">
			<xsl:value-of select="$userId" />
		</xsl:attribute>
	</xsl:template>

	<xsl:template
		match="t:ClinicalDocument/t:assignedAuthor/t:representedOrganization/t:id/@extension">
		<xsl:attribute name="extension">
			<xsl:value-of select="$userFacilityNumber" />
		</xsl:attribute>
	</xsl:template>

</xsl:stylesheet>
