package gov.va.med.nhin.adapter.patientdiscovery;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.med.nhin.adapter.utils.NullChecker;

/**
 * Utility for date and time.
 * 
 * @author Asha Amritraj
 */
public class HL7DateUtil
{
	private static final Logger logger = LoggerFactory.getLogger(HL7DateUtil.class.getName());

	public static Date dateFromString(final String s) throws ParseException
	{

		if(NullChecker.isNullOrEmpty(s))
		{
			return null;
		}
		Date date = null;
		SimpleDateFormat ofd = null;
		try
		{
			// 19920603131438-0500
			// ofd = new SimpleDateFormat("yyyyMMddhhmmssZ");
			ofd = new SimpleDateFormat("yyyyMMddkkmmssZ");
			date = ofd.parse(s);
			return date;
		}
		catch(final ParseException ex)
		{
			logger.error("error occurred during parsing: ", ex);
		}
		
		return date;
	}

	public static String yyyyMMddhhmmssZ(final Date date) throws ParseException
	{

		if(NullChecker.isNullOrEmpty(date))
		{
			return null;
		}
		// final SimpleDateFormat ofd = new SimpleDateFormat("yyyyMMddhhmmssZ");
		final SimpleDateFormat ofd = new SimpleDateFormat("yyyyMMddkkmmssZ");
		final String dateString = ofd.format(date);
		
		logger.debug("date: ", dateString);
		
		return dateString;
	}
}
