package gov.va.med.nhin.adapter.patientcorrelation.ack;

import org.hl7.v3.II;
import org.hl7.v3.MCCIIN000002UV01;
import org.hl7.v3.MCCIMT000200UV01Acknowledgement;
import org.hl7.v3.MCCIMT000200UV01TargetMessage;
import org.hl7.v3.PRPAIN201301UV02;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.med.nhin.adapter.patientcorrelation.parsers.helpers.CSHelper;
import gov.va.med.nhin.adapter.patientcorrelation.parsers.helpers.Configuration;
import gov.va.med.nhin.adapter.patientcorrelation.parsers.helpers.CreationTimeHelper;
import gov.va.med.nhin.adapter.patientcorrelation.parsers.helpers.IIHelper;
import gov.va.med.nhin.adapter.patientcorrelation.parsers.helpers.InteractionIdHelper;
import gov.va.med.nhin.adapter.patientcorrelation.parsers.helpers.SenderReceiverHelperMCCIMT000200UV01;
import gov.va.med.nhin.adapter.patientcorrelation.parsers.helpers.UniqueIdHelper;

/**
 *
 * @author rayj
 */
public class AckBuilder
{
	// CCR 177986
	private static final Logger logger = LoggerFactory.getLogger(AckBuilder.class.getName());

	private static final String AcceptAckCodeValue = "NE";
	private static final String ITSVersion = "XML_1.0";
	private static final String InteractionIdExtension = "MCCI_IN000002UV01";
	private static final String ProcessingCodeValue = "P";
	private static final String ProcessingModeCode = "R";

	public static MCCIIN000002UV01 BuildAck(PRPAIN201301UV02 originalMessage)
	{
		II receiverId = null;
		II senderId = null;
		String acknowledgementTypeCode = "CA";
		II originalMessageId = null;

		if(originalMessage != null)
		{
			if((originalMessage.getSender() != null) && (originalMessage.getSender().getDevice() != null) && (originalMessage.getSender().getDevice().getId() != null) && (originalMessage.getSender().getDevice().getId().size() > 0))
			{
				receiverId = originalMessage.getSender().getDevice().getId().get(0);
			}

			originalMessageId = originalMessage.getId();

			logger.debug("original MessageId {} ", originalMessageId);
		}

		senderId = IIHelper.IIFactory(Configuration.getMyCommunityId(), null);

		logger.debug("Sender Id {} ", senderId);

		MCCIIN000002UV01 ack = BuildAck(receiverId, senderId, acknowledgementTypeCode, originalMessageId);

		// CCR 177986
		logger.debug("MCCIIN000002UV01 ack {}", ack);

		return ack;
	}

	public static MCCIIN000002UV01 BuildAck(II receiverId, II senderId, String acknowledgementTypeCode, II originalMessageId)
	{
		MCCIIN000002UV01 message = new MCCIIN000002UV01();

		message.setITSVersion(ITSVersion);
		message.setId(UniqueIdHelper.createUniqueId());
		message.setCreationTime(CreationTimeHelper.getCreationTime());
		message.setInteractionId(InteractionIdHelper.createInteractionId(InteractionIdExtension));

		message.setProcessingCode(CSHelper.buildCS(ProcessingCodeValue));
		message.setProcessingModeCode(CSHelper.buildCS(ProcessingModeCode));
		message.setAcceptAckCode(CSHelper.buildCS(AcceptAckCodeValue));

		message.getReceiver().add(SenderReceiverHelperMCCIMT000200UV01.CreateReceiver(receiverId));
		message.setSender(SenderReceiverHelperMCCIMT000200UV01.CreateSender(senderId));

		MCCIMT000200UV01Acknowledgement acknowledgement = new MCCIMT000200UV01Acknowledgement();
		acknowledgement.setTypeCode(CSHelper.buildCS(acknowledgementTypeCode));
		MCCIMT000200UV01TargetMessage targetMessage = new MCCIMT000200UV01TargetMessage();
		targetMessage.setId(originalMessageId);
		acknowledgement.setTargetMessage(targetMessage);
		message.getAcknowledgement().add(acknowledgement);

		// CCR 177986
		logger.debug("MCCIIN000002UV01 message {}", message);

		return message;
	}
}
