package gov.va.med.nhin.adapter.docretrieve;

import javax.ejb.EJB;
import javax.ejb.*;
import javax.jws.WebService;
import javax.xml.ws.BindingType;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.hhs.fha.nhinc.adapterdocretrieve.AdapterDocRetrievePortType;
import gov.hhs.fha.nhinc.adapterpolicyengine.AdapterPolicyEnginePortType;
import gov.hhs.fha.nhinc.common.eventcommon.DocRetrieveEventType;
import gov.hhs.fha.nhinc.common.eventcommon.DocRetrieveMessageType;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.CheckPolicyRequestType;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.CheckPolicyResponseType;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.RespondingGatewayCrossGatewayRetrieveRequestType;
import gov.hhs.fha.nhinc.nhinclib.NhincConstants;
import gov.hhs.fha.nhinc.transform.policy.PolicyEngineTransformer;
import gov.va.med.nhin.adapter.errors.CreateErrorInterface;
import gov.va.med.nhin.adapter.facilitymanager.FacilityManager;
import gov.va.med.nhin.adapter.facilitymanager.FacilityManagerLocal;
import gov.va.med.nhin.adapter.facilitymanager.OperationOnOff;
import gov.va.med.nhin.adapter.logging.ErrorMessage;
import gov.va.med.nhin.adapter.logging.EventAuditingFactory;
import gov.va.med.nhin.adapter.logging.EventAuditingFactoryImpl;
import gov.va.med.nhin.adapter.logging.LogConstants;
import gov.va.med.nhin.adapter.logging.LogConstants.AuditingEvent;
import gov.va.med.nhin.adapter.logging.MessagingHelper;
import gov.va.med.nhin.adapter.logging.MessagingHelper.QueryType;
import gov.va.med.nhin.adapter.policyengine.AdapterPolicyEnginePortTypeLocal;
import gov.va.med.nhin.adapter.utils.NullChecker;
import ihe.iti.xds_b._2007.RetrieveDocumentSetResponseType;
import javax.jws.HandlerChain;
import javax.xml.ws.soap.MTOM;
import oasis.names.tc.xacml._2_0.context.schema.os.DecisionType;
import org.hl7.fhir.dstu3.model.AuditEvent;

/**
 *
 * @author David Vazquez
 */
@WebService(serviceName = "AdapterDocRetrieveSoap12",
            portName = "AdapterDocRetrievePortSoap",
            endpointInterface = "gov.hhs.fha.nhinc.adapterdocretrieve.AdapterDocRetrievePortType",
            targetNamespace = "urn:gov:hhs:fha:nhinc:adapterdocretrieve"/*,
            wsdlLocation = "META-INF/wsdl/AdapterDocRetrieveSoap12.wsdl"*/)
@BindingType(value = javax.xml.ws.soap.SOAPBinding.SOAP12HTTP_BINDING)
@HandlerChain(file = "SOAPHandlerChain.xml")
@TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
@Stateless(name = "AdapterDocRetrieve")
@MTOM(enabled = true)
public class AdapterDocRetrieve implements AdapterDocRetrievePortTypeLocal
{
    private static final Logger logger = LoggerFactory.getLogger(AdapterDocRetrieve.class.getName());

    static private final String ERROR_XDS_REPOSITORY_ERROR = "XDSRepositoryError";
    static private final String ERROR_DESC_XDS_REPOSITORY_ERROR = "Internal Registry/Repository Error";
    static private final String ERROR_XDS_DOCUMENT_UNIQUE_ID_ERROR = "XDSDocumentUniqueIdError";
    static private final String ERROR_DESC_XDS_DOCUMENT_UNIQUE_ID_ERROR = "Document is not Available";

    private AdapterDocRetrievePortType docRetrieve;
    private AdapterPolicyEnginePortType policyEngine;
    private FacilityManager facilityManager;
    private CreateErrorInterface errorResponse;

    @EJB(beanInterface = CreateErrorInterface.class, beanName = "CreateResponseError")
    public void setErrorResponse(CreateErrorInterface errorResponse)
    {
        this.errorResponse = errorResponse;
    }

    @EJB(beanInterface = AdapterDocRetrievePortTypeLocal.class, beanName = "DocRetrieve")
    public void setDocRetrieve(AdapterDocRetrievePortType docRetrieve)
    {
        this.docRetrieve = docRetrieve;
    }

    @EJB(beanInterface = AdapterPolicyEnginePortTypeLocal.class, beanName = "AdapterPolicyEngine")
    public void setPolicyEngine(AdapterPolicyEnginePortType policyEngine)
    {
        this.policyEngine = policyEngine;
    }

    @EJB(beanInterface = FacilityManagerLocal.class, beanName = "FacilityManager")
    public void setFacilityManager(FacilityManager facilityManager)
    {
        this.facilityManager = facilityManager;
    }

    @Override
    public RetrieveDocumentSetResponseType respondingGatewayCrossGatewayRetrieve(RespondingGatewayCrossGatewayRetrieveRequestType respondingGatewayCrossGatewayRetrieveRequest)
    {
        EventAuditingFactory<AuditEvent> afac
                                         = EventAuditingFactoryImpl.getFactory(AuditEvent.class);
        afac.info(afac.newEvent(respondingGatewayCrossGatewayRetrieveRequest.getAssertion(),
                                LogConstants.AuditingEvent.RDIN_BEGIN, getClass()));

        String partnerCommunityId = respondingGatewayCrossGatewayRetrieveRequest.getAssertion().getHomeCommunity().getHomeCommunityId();
        logger.debug("Starting  AdapterDocRetrieveA (2010 Spec) - Call and Partner Homecommunity ID is {} ", partnerCommunityId); // CCR177986

        RetrieveDocumentSetResponseType ret = null;
        boolean alreadyLoggedEnd = false;
        try {
            AuditEvent eventPolicyCheck = afac.messaging().partnerauth(AuditingEvent.RDIN_PARTNERAUTH, getClass(), partnerCommunityId);
            if (facilityManager.isPartnerAllowed(partnerCommunityId, OperationOnOff.ONBOARD)) {
                if (facilityManager.isPartnerAllowed(partnerCommunityId, OperationOnOff.IN_DR)) {

                    if (checkPolicy(respondingGatewayCrossGatewayRetrieveRequest, eventPolicyCheck)) {

                        eventPolicyCheck.setOutcome(AuditEvent.AuditEventOutcome._0);
                        afac.info(eventPolicyCheck);

                        afac.info(AuditingEvent.RDIN_DISCLOSEOK, getClass());

                        ret = docRetrieve.respondingGatewayCrossGatewayRetrieve(respondingGatewayCrossGatewayRetrieveRequest);

                        logger.debug("for valid policy RetrieveDocumentSetResponseType ret {} ", ret);
                    }
                    else {
                        eventPolicyCheck.setOutcome(AuditEvent.AuditEventOutcome._4);
                        eventPolicyCheck.setOutcomeDesc("Failed Policy Check / Document with error for RetrieveDocumentSetResponseType");
                        afac.error(eventPolicyCheck);
                        ret = errorResponse.createRetrieveDocumentError(ERROR_XDS_DOCUMENT_UNIQUE_ID_ERROR, ERROR_DESC_XDS_DOCUMENT_UNIQUE_ID_ERROR);

                        // CCR 177986 - logging
                        logger.debug("Document with error for  RetrieveDocumentSetResponseType ret {} ", ret);
                    }

                }
                else {
                    eventPolicyCheck.setOutcome(AuditEvent.AuditEventOutcome._4);
                    eventPolicyCheck.setOutcomeDesc(ErrorMessage.IN_DR_DISABLED.getMessage());
                    afac.error(eventPolicyCheck);

                    logger.debug("NOT ALLOWED TO DO DR - It is turned OFF");
                    ret = errorResponse.createRetrieveDocumentError(ErrorMessage.IN_DR_DISABLED);

                    // CCR 177986 - logging
                    logger.debug("Document with error for  RetrieveDocumentSetResponseType ret {} ", ret);
                }
            }
            else {
                eventPolicyCheck.setOutcome(AuditEvent.AuditEventOutcome._4);
                eventPolicyCheck.setOutcomeDesc(ErrorMessage.IN_DR_NOT_A_PARTNER.getMessage());
                afac.error(eventPolicyCheck);

                logger.debug("<<<<NOT ALLOWED TO ANY OPERATIONS - NOT INBOARD TO VA >>>>>> {}");
                ret = errorResponse.createRetrieveDocumentError(ErrorMessage.IN_DR_NOT_A_PARTNER);

                // CCR 177986 - logging
                logger.debug("Document with error for  RetrieveDocumentSetResponseType ret {} ", ret);
            }
        }
        catch (Throwable t) {
            String hcid;
            String hcidName;
            if (respondingGatewayCrossGatewayRetrieveRequest.getAssertion() != null && respondingGatewayCrossGatewayRetrieveRequest.getAssertion().getHomeCommunity() != null) {
                hcid = respondingGatewayCrossGatewayRetrieveRequest.getAssertion().getHomeCommunity().getHomeCommunityId();
                hcidName = respondingGatewayCrossGatewayRetrieveRequest.getAssertion().getHomeCommunity().getName();
            }
            else {
                hcid = "N/A";
                hcidName = "Not Available";
            }

            AuditEvent event = afac.newEvent(AuditingEvent.RDIN_END, getClass());
            event.setOutcome(AuditEvent.AuditEventOutcome._8);
            event.setOutcomeDesc("Error processing DocRetrieve");
            afac.error(event);
            alreadyLoggedEnd = true;

            // CCR 177986
            logger.error("Error processing DocRetrieve from {} {} - {}", hcid, hcidName, t.getMessage());
            logger.error("Stack trace for AdapterDocRetrieveA (2010 Spec) {} ", t);
            ret = errorResponse.createRetrieveDocumentError(ERROR_XDS_REPOSITORY_ERROR, ERROR_DESC_XDS_REPOSITORY_ERROR);

            // CCR 177986 - logging
            logger.debug("Document with error for  RetrieveDocumentSetResponseType ret {} ", ret);
        }

        if (!alreadyLoggedEnd) {
            afac.info(LogConstants.AuditingEvent.RDIN_END, getClass());
        }
        return ret;
    }

    private boolean checkPolicy(RespondingGatewayCrossGatewayRetrieveRequestType respondingGatewayCrossGatewayRetrieveRequest, AuditEvent ae)
    {
        DocRetrieveMessageType docRetrieveMessage = new DocRetrieveMessageType();
        docRetrieveMessage.setAssertion(respondingGatewayCrossGatewayRetrieveRequest.getAssertion());
        docRetrieveMessage.setRetrieveDocumentSetRequest(respondingGatewayCrossGatewayRetrieveRequest.getRetrieveDocumentSetRequest());

        DocRetrieveEventType docRetrieveEvent = new gov.hhs.fha.nhinc.common.eventcommon.DocRetrieveEventType();

        // CCR 177986
        logger.debug("docRetrieveMessage {}", docRetrieveMessage);

        docRetrieveEvent.setMessage(docRetrieveMessage);
        docRetrieveEvent.setDirection(NhincConstants.POLICYENGINE_INBOUND_DIRECTION);

        // CCR 177986
        logger.debug(" docRetrieveEvent {}", docRetrieveEvent);

        PolicyEngineTransformer policyEngineTransformer = new PolicyEngineTransformer();
        CheckPolicyRequestType checkPolicyRequest = policyEngineTransformer.transformDocRetrieveToCheckPolicy(docRetrieveEvent);

        // CCR 177986
        logger.debug("CheckPolicyRequestType checkPolicyRequest {}", checkPolicyRequest);

        MessagingHelper<AuditEvent> msg = EventAuditingFactoryImpl.getFactory(AuditEvent.class).messaging();
        msg.addQuery(ae, checkPolicyRequest, CheckPolicyRequestType.class,
                     QueryType.REQUEST, null);
        CheckPolicyResponseType checkPolicyResponse = policyEngine.checkPolicy(checkPolicyRequest);
        msg.addQuery(ae, checkPolicyResponse, CheckPolicyResponseType.class,
                     QueryType.RESPONSE, null);

        // CCR 177986
        logger.debug("CheckPolicyResponseType checkPolicyResponse {}", checkPolicyResponse);

        return checkPolicyResponse != null
               && checkPolicyResponse.getResponse() != null
               && NullChecker.isNotNullOrEmpty(checkPolicyResponse.getResponse().getResult())
               && checkPolicyResponse.getResponse().getResult().get(0).getDecision() == DecisionType.PERMIT;
    }
}
