/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.async;

import gov.va.med.nhin.adapter.adaptergateway.patientannounce.AnnouncePatient;
import gov.va.med.nhin.adapter.adaptergateway.patientdiscovery.EntityPatientDiscoveryPortTypeLocal;
import gov.va.med.nhin.adapter.announcepatient.AnnouncePatientResponseType;
import gov.va.med.nhin.adapter.announcepatient.AnnouncePatientType;
import gov.va.med.nhin.adapter.announcepatient.AnnouncePatientType.Facilities;
import gov.va.med.nhin.adapter.audit.AuditManagerLocal;
import gov.va.med.nhin.adapter.audit.requests.RequestAudit;
import gov.va.med.nhin.adapter.datamanager.DataManager;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.SmartHashMap;
import gov.va.med.nhin.adapter.datamanager.ejb.DataManagerLocal;
import gov.va.med.nhin.adapter.facilitymanager.FacilityManagerLocal;
import gov.va.med.nhin.adapter.permission.UserInfoType;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookupLocal;
import gov.va.med.nhin.adapter.utils.LogUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.jws.WebService;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.ejb.Stateless;
import org.slf4j.LoggerFactory;

/**
 * An endpoint to support the Asynchronous Subscription Service. We're trying to
 * make it as easy as possible to hook into the DataManager from external
 * websites.
 *
 * @author ryan
 */
@WebService( serviceName = "AsyncSubscriptionEndpoint" )
@Stateless()
public class AsyncSub {

	@EJB( beanInterface = DataManagerLocal.class, beanName = "DataManager" )
	private DataManager datamgr;

	@EJB( beanInterface = PropertyLookupLocal.class, beanName = "PropertyFileLookup" )
	private PropertyLookupLocal propertyLookup;

	@EJB( beanInterface = AuditManagerLocal.class, beanName = "AuditManager" )
	private AuditManagerLocal auditor;

	@EJB( beanInterface = FacilityManagerLocal.class, beanName = "FacilityManager" )
	private FacilityManagerLocal facmgr;

	@EJB( beanInterface = EntityPatientDiscoveryPortTypeLocal.class, beanName = "AdapterGatewayPatientDiscovery" )
	private EntityPatientDiscoveryPortTypeLocal pd;

	@EJB( beanInterface = RequestAudit.class, beanName = "RequestAudit" )
	private RequestAudit requestAudit;

	/**
	 * This is a sample web service operation
	 *
	 * @param pid
	 * @return
	 */
	@WebMethod( operationName = "findNHINCorrelations" )
	public String[] findCorrelations( @WebParam( name = "patientId" ) String pid ) {
		DataQuery dq = datamgr.getQuery( "MPI.findNHINCorrelations" );
		dq.setParameter( "icn", pid );

		Set<String> nhios = new HashSet<>();
		List<SmartHashMap> list = dq.getResults();
		for ( SmartHashMap o : list ) {
			nhios.add( o.get( "correlatedAssigningFacility" ).toString() );
			LoggerFactory.getLogger( getClass() ).error(LogUtil.cleanLogMessage( o.toString() ) );
		}

		return nhios.toArray( new String[]{} );
	}

	@WebMethod( operationName = "announcePatient" )
	public int announce( @WebParam( name = "patientId" ) String pid ) {
		AnnouncePatientType apt = new AnnouncePatientType();
		apt.setHieTransactionId( null );

		//Facilities facs = new Facilities();
		//facs.getFacility().add( "200DOD" );

		//apt.setFacilities( facs );

		UserInfoType ut = new UserInfoType();
		ut.setFullName( "Async User" );
		ut.setAuthenticationMethod( "password" );
		ut.setUserId( pid );
		apt.setUserInfo( ut );

		apt.setPatientId( pid );
		// FIXME: I think we should be able to inject this, but can't figure out how
		AnnouncePatient announcer = new AnnouncePatient();

		announcer.setAuditManager( auditor );
		announcer.setDataManager( datamgr );
		announcer.setEntityPatientDiscovery( pd );
		announcer.setFacilityManager( facmgr );
		announcer.setPropertyLookup( propertyLookup );
		announcer.setRequestAudit( requestAudit );

		AnnouncePatientResponseType aprt = announcer.announcePatient( apt );

		return aprt.getReturn();
	}
}
