package gov.va.med.nhin.adapter.adaptergateway.patientdiscovery;

import com.sun.xml.ws.client.BindingProviderProperties;
import java.net.MalformedURLException;
import java.net.URL;

import javax.ejb.EJB;
import javax.ejb.*;
import javax.xml.namespace.QName;

import org.hl7.v3.PRPAIN201305UV02;
import org.hl7.v3.PRPAIN201306UV02;
import org.hl7.v3.RespondingGatewayPRPAIN201305UV02RequestType;
import org.hl7.v3.RespondingGatewayPRPAIN201306UV02ResponseType;

import gov.hhs.fha.nhinc.common.nhinccommon.AssertionType;
import gov.hhs.fha.nhinc.common.nhinccommon.HomeCommunityType;
import gov.hhs.fha.nhinc.common.nhinccommon.NhinTargetCommunitiesType;
import gov.hhs.fha.nhinc.common.nhinccommon.NhinTargetCommunityType;
import gov.hhs.fha.nhinc.entitypatientdiscovery.EntityPatientDiscovery;
import gov.hhs.fha.nhinc.entitypatientdiscovery.EntityPatientDiscoveryPortType;
import gov.va.med.nhin.adapter.logging.EventAuditingFactoryImpl;
import gov.va.med.nhin.adapter.logging.MessagingHelper;
import gov.va.med.nhin.adapter.logging.MessagingHelper.QueryType;
import gov.va.med.nhin.adapter.utils.soap.handler.SOAPHandlerResolver;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookup;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookupLocal;
import java.util.Map;
import javax.xml.ws.BindingProvider;
import org.hl7.fhir.dstu3.model.AuditEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author DNS   VAZQUD
 */
@TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
@Stateless(name = "NhincProxyNHINPatientDiscoverySender")
public class NhincProxyNHINPatientDiscoverySender implements NHINPatientDiscoverySender
{
    private static final Logger logger = LoggerFactory.getLogger(NhincProxyNHINPatientDiscoverySender.class.getName());
    private PropertyLookup propertyLookup;
    private EntityPatientDiscovery entityPatientDiscovery;

    @EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyFileLookup")
    public void setPropertyLookup(PropertyLookup propertyLookup)
    {
        this.propertyLookup = propertyLookup;
    }

    @Override
    public PRPAIN201306UV02 sendRequest(PRPAIN201305UV02 prpain201305, AssertionType assertion,
                                        String remoteHomeCommunityId, AuditEvent event)
    {
        logger.debug("Entering NhincProxyNHINPatientDiscoverySender::sendRequest");

        PRPAIN201306UV02 ret = null;

        try {
            RespondingGatewayPRPAIN201305UV02RequestType request = new RespondingGatewayPRPAIN201305UV02RequestType();

            request.setAssertion(assertion);
            request.setPRPAIN201305UV02(prpain201305);
            request.setNhinTargetCommunities(createNhinTargetCommunities(remoteHomeCommunityId));

            //changed on 02/01/2017 (EHX-12)
            logger.debug("Implementing timeout properties!");
            EntityPatientDiscoveryPortType port = getPatientDiscoveryEntityPort();
            Map<String, Object> requestContext = ((BindingProvider)port).getRequestContext();
            requestContext.put(BindingProviderProperties.REQUEST_TIMEOUT, Integer.parseInt(propertyLookup.getProperty("REQUEST_TIMEOUT")));
            requestContext.put(BindingProviderProperties.CONNECT_TIMEOUT, Integer.parseInt(propertyLookup.getProperty("CONNECT_TIMEOUT")));

            MessagingHelper<AuditEvent> msg
                                        = EventAuditingFactoryImpl.getFactory(AuditEvent.class).messaging();
            if (null != event) {
                msg.addQuery(event, request, RespondingGatewayPRPAIN201305UV02RequestType.class,
                             QueryType.REQUEST, null);
            }

            RespondingGatewayPRPAIN201306UV02ResponseType response = port.respondingGatewayPRPAIN201305UV02(request);
            if (null != event) {
                msg.addQuery(event, request, RespondingGatewayPRPAIN201306UV02ResponseType.class,
                             QueryType.RESPONSE, null);
            }

            ret = response.getCommunityResponse().get(0).getPRPAIN201306UV02();

        }
        catch (MalformedURLException t) {
            logger.error("Sending request failed due to {}", t);
        }
        return ret;
    }

    private NhinTargetCommunitiesType createNhinTargetCommunities(String homeCommunityId)
    {

        HomeCommunityType homeCommunity = new HomeCommunityType();
        homeCommunity.setHomeCommunityId(homeCommunityId);

        NhinTargetCommunityType homeTargetCommunity = new NhinTargetCommunityType();
        homeTargetCommunity.setHomeCommunity(homeCommunity);

        NhinTargetCommunitiesType ret = new NhinTargetCommunitiesType();
        ret.getNhinTargetCommunity().add(homeTargetCommunity);

        return ret;
    }

    private EntityPatientDiscoveryPortType getPatientDiscoveryEntityPort() throws MalformedURLException
    {
        if (entityPatientDiscovery == null) {
            entityPatientDiscovery = new EntityPatientDiscovery(new URL(propertyLookup.getProperty("PatientDiscoveryProxyWSDL")), new QName("urn:gov:hhs:fha:nhinc:entitypatientdiscovery", "EntityPatientDiscovery"));
            entityPatientDiscovery.setHandlerResolver(new SOAPHandlerResolver(true));
        }

        return entityPatientDiscovery.getEntityPatientDiscoveryPortSoap();
    }
}
