package gov.va.med.nhin.adapter.adaptergateway.docquery;

import com.sun.xml.ws.client.BindingProviderProperties;
import gov.hhs.fha.nhinc.common.nhinccommon.AssertionType;
import gov.hhs.fha.nhinc.common.nhinccommon.HomeCommunityType;
import gov.hhs.fha.nhinc.common.nhinccommon.NhinTargetCommunitiesType;
import gov.hhs.fha.nhinc.common.nhinccommon.NhinTargetCommunityType;
import gov.hhs.fha.nhinc.entitydocquery.EntityDocQuery;
import gov.hhs.fha.nhinc.entitydocquery.EntityDocQueryPortType;
import gov.va.med.nhin.adapter.utils.soap.handler.SOAPHandlerResolver;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookup;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookupLocal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

import javax.ejb.EJB;
import javax.ejb.*;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;

import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryRequest;
import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 *
 * @author David Vazquez
 */
@TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
@Stateless(name = "NhincProxyNHINDocQueryRequestSender")
public class NhincProxyNHINDocQueryRequestSender implements NHINDocQueryRequestSender
{
    private static Log log = LogFactory.getLog(NhincProxyNHINDocQueryRequestSender.class);

    private EntityDocQuery entityDocQuery;
    private PropertyLookup propertyLookup;

    @EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyFileLookup")
    public void setPropertyLookup(PropertyLookup propertyLookup)
    {
        this.propertyLookup = propertyLookup;
    }

    public AdhocQueryResponse sendRequest(AdhocQueryRequest adhocQueryRequest, AssertionType assertion, String remoteHomeCommunityId, String useSpecVersion)
    {
        log.debug("Entering NhincProxyNHINDocQueryRequestSender::sendRequest");

        AdhocQueryResponse ret = null;

        try {
            final gov.hhs.fha.nhinc.common.nhinccommonentity.RespondingGatewayCrossGatewayQueryRequestType request = new gov.hhs.fha.nhinc.common.nhinccommonentity.RespondingGatewayCrossGatewayQueryRequestType();
            request.setAdhocQueryRequest(adhocQueryRequest);
            request.setAssertion(assertion);
            request.setNhinTargetCommunities(createNhinTargetCommunities(remoteHomeCommunityId, useSpecVersion));

            //Changed on 2/1/2017 (EHX-12)
            log.debug("Implementing timeout properties!");
            EntityDocQueryPortType port = getDocQueryEntityPort();
            Map<String, Object> requestContext = ((BindingProvider)port).getRequestContext();
            requestContext.put(BindingProviderProperties.REQUEST_TIMEOUT, Integer.parseInt(propertyLookup.getProperty("REQUEST_TIMEOUT"))); //Timeout on waiting to read data
            requestContext.put(BindingProviderProperties.CONNECT_TIMEOUT, Integer.parseInt(propertyLookup.getProperty("CONNECT_TIMEOUT"))); //To timeout the initial connection

            ret = port.respondingGatewayCrossGatewayQuery(request);
        }
        catch (MalformedURLException t) {
            log.error("Sending request failed due to {}", t);
        }
        return ret;
    }

    private NhinTargetCommunitiesType createNhinTargetCommunities(String homeCommunityId, String useSpecVersion)
    {
        HomeCommunityType homeCommunity = new HomeCommunityType();
        homeCommunity.setHomeCommunityId(homeCommunityId);

        NhinTargetCommunityType homeTargetCommunity = new NhinTargetCommunityType();
        homeTargetCommunity.setHomeCommunity(homeCommunity);

        NhinTargetCommunitiesType ret = new NhinTargetCommunitiesType();
        ret.getNhinTargetCommunity().add(homeTargetCommunity);
        ret.setUseSpecVersion(useSpecVersion);

        return ret;
    }

    private EntityDocQueryPortType getDocQueryEntityPort() throws MalformedURLException
    {
        if (entityDocQuery == null) {
            entityDocQuery = new EntityDocQuery(new URL(propertyLookup.getProperty("DocQueryProxyWSDL")), new QName("urn:gov:hhs:fha:nhinc:entitydocquery", "EntityDocQuery"));
            entityDocQuery.setHandlerResolver(new SOAPHandlerResolver(true));
        }
        return entityDocQuery.getEntityDocQueryPortSoap();
    }
}
