package gov.va.med.nhin.adapter.adaptergateway.patientdiscovery;

import java.net.URL;

import javax.ejb.EJB;
import javax.ejb.*;
import javax.xml.namespace.QName;

import org.hl7.v3.RespondingGatewayPRPAIN201305UV02RequestType;
import org.hl7.v3.RespondingGatewayPRPAIN201306UV02ResponseType;

import gov.hhs.fha.nhinc.entitypatientdiscovery.EntityPatientDiscovery;
import gov.hhs.fha.nhinc.entitypatientdiscovery.EntityPatientDiscoveryPortType;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookup;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookupLocal;

/**
 *
 * @author DNS   VAZQUD
 */
@TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
@Stateless(name = "AdapterGatewayPatientDiscoveryWS")
public class AdapterGatewayPatientDiscoveryWS implements EntityPatientDiscoveryPortTypeLocal
{
	private PropertyLookup propertyLookup;
	private EntityPatientDiscovery service;

	@EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyFileLookup")
	public void setPropertyLookup(PropertyLookup propertyLookup)
	{
		this.propertyLookup = propertyLookup;
	}

	public RespondingGatewayPRPAIN201306UV02ResponseType respondingGatewayPRPAIN201305UV02(RespondingGatewayPRPAIN201305UV02RequestType r)
	{
		try
		{
			return getEntityPatientDiscoveryPort().respondingGatewayPRPAIN201305UV02(r);
		}
		catch(Throwable t)
		{
			throw new UnsupportedOperationException("Not supported yet!");
		}
	}

	private EntityPatientDiscoveryPortType getEntityPatientDiscoveryPort()
	{
		EntityPatientDiscoveryPortType ret;

		try
		{
			if(service == null)
			{
				String entityPatientDiscoveryWSDL = propertyLookup.getProperty("EntityPatientDiscoveryWSDL");
				URL url = new URL(entityPatientDiscoveryWSDL);
				QName qname = new QName("urn:gov:hhs:fha:nhinc:entitypatientdiscovery", "EntityPatientDiscovery");
				service = new EntityPatientDiscovery(url, qname);
			}

			ret = service.getEntityPatientDiscoveryPortSoap();
		}
		catch(Exception e)
		{
			throw new RuntimeException("Error getting EntityPatientDiscoveryPort");
		}

		return ret;
	}
}
