package gov.va.med.nhin.adapter.adaptergateway.docretrieve;

import java.net.URL;

import javax.ejb.EJB;
import javax.ejb.*;
import javax.xml.namespace.QName;

import gov.hhs.fha.nhinc.common.nhinccommonentity.RespondingGatewayCrossGatewayRetrieveRequestType;
import gov.hhs.fha.nhinc.entitydocretrieve.EntityDocRetrieve;
import gov.hhs.fha.nhinc.entitydocretrieve.EntityDocRetrievePortType;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookup;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookupLocal;
import ihe.iti.xds_b._2007.RetrieveDocumentSetResponseType;

/**
 *
 * @author DNS   VAZQUD
 */
@TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
@Stateless(name = "AdapterGatewayDocRetrieveWS")
public class AdapterGatewayDocRetrieveWS implements EntityDocRetrievePortTypeLocal
{
	private EntityDocRetrieve entityDocRetrieve;
	private PropertyLookup propertyLookup;

	@EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyFileLookup")
	public void setPropertyLookup(PropertyLookup propertyLookup)
	{
		this.propertyLookup = propertyLookup;
	}

	public RetrieveDocumentSetResponseType respondingGatewayCrossGatewayRetrieve(RespondingGatewayCrossGatewayRetrieveRequestType rgcgrt)
	{
		try
		{
			return getEntityDocRetrievePort().respondingGatewayCrossGatewayRetrieve(rgcgrt);
		}
		catch(Exception e)
		{
			throw new UnsupportedOperationException("Not supported yet.");
		}
	}

	private EntityDocRetrievePortType getEntityDocRetrievePort() throws Exception
	{
		if(entityDocRetrieve == null)
		{
			URL url = new URL(propertyLookup.getProperty("EntityDocRetrieveWSDL"));
			QName qname = new QName("urn:gov:hhs:fha:nhinc:entitydocretrieve", "EntityDocRetreive");
			entityDocRetrieve = new EntityDocRetrieve(url, qname);
		}

		return entityDocRetrieve.getEntityDocRetrievePortSoap();
	}
}
