package gov.va.med.nhin.adapter.adaptergateway.docquery;

import gov.hhs.fha.nhinc.common.nhinccommonentity.RespondingGatewayCrossGatewayQueryRequestType;
import gov.hhs.fha.nhinc.entitydocquery.EntityDocQuery;
import gov.hhs.fha.nhinc.entitydocquery.EntityDocQueryPortType;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookup;
import gov.va.med.nhin.adapter.propertylookup.PropertyLookupRemote;

import java.net.URL;

import javax.ejb.EJB;
import javax.xml.namespace.QName;

import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryResponse;

/**
 * 
 * @author DNS   VAZQUD
 */
@EJB(name = "AdapterGatewayDocQueryWS")
public class EntityDocQueryWSBean implements EntityDocQueryPortTypeLocal
{
	private EntityDocQuery entityDocQuery;
	private PropertyLookup propertyLookup;

	@EJB(beanInterface = PropertyLookupRemote.class, beanName = "PropertyFileLookup")
	public void setPorpertyLookup(PropertyLookup propertyLookup)
	{
		this.propertyLookup = propertyLookup;
	}

	public AdhocQueryResponse respondingGatewayCrossGatewayQuery(RespondingGatewayCrossGatewayQueryRequestType r)
	{
		try
		{
			return getEntityDocQueryPort().respondingGatewayCrossGatewayQuery(r);
		}
		catch(Exception e)
		{
			throw new UnsupportedOperationException("Not supported yet.", e);
		}
	}

	private EntityDocQueryPortType getEntityDocQueryPort() throws Exception
	{
		if(entityDocQuery == null)
		{
			URL url = new URL(propertyLookup.getProperty("EntityDocQueryWSDL"));
			QName qname = new QName("urn:gov:hhs:fha:nhinc:entitydocquery", "EntityDocQuery");
			entityDocQuery = new EntityDocQuery(url, qname);
		}

		return entityDocQuery.getEntityDocQueryPortSoap();
	}
}
