package gov.va.med.nhin.adapter.dataquality.dh;

import static com.github.tomakehurst.wiremock.client.WireMock.*;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import gov.va.med.nhin.adapter.dataquality.common.RestClientException;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;

import org.apache.commons.io.IOUtils;

import static org.junit.Assert.*;
import org.junit.Rule;
import org.junit.Test;

/**
 *
 * @author cbarber
 */
public class DHUploadTest
{
	public static final int MOCK_PORT = PORT;
	@Rule
	public WireMockRule wireMockRule = new WireMockRule(MOCK_PORT); // No-args constructor defaults to port PORT

	public DHUploadTest()
	{
	}

	@Test
	public void testUploadDoc() throws IOException, URISyntaxException, RestClientException
	{
		URL sampleRespRsrc = getClass().getResource("/GoodUploadResponse.json");
                System.out.println("sampleRespRsrc: "+sampleRespRsrc);
                assertNotEquals(null,sampleRespRsrc);
		String sampleRespString = IOUtils.toString(sampleRespRsrc.toURI(), StandardCharsets.UTF_8);
		stubFor(
			post(urlMatching("/document.*"))
			.withHeader("Accept", equalTo("application/json"))
			.willReturn(
				aResponse()
				.withStatus(200)
				.withHeader("Content-Type", "application/json")
				.withBody(sampleRespString)
			)
		);

		InputStream docInput = getClass().getResourceAsStream("/374117_CCDACCD_20161202.xml");
                System.out.println("docInput: "+docInput);
                assertNotEquals(null,docInput);
		DHUpload dhUploader = new DHUpload();
                System.out.println("DHUpload uploadDoc() attempting to upload file to DH wiremock: "+"374117_CCDACCD_20161202.xml");
                
		String returnedId = dhUploader.uploadDoc(
			"http://localhost:" + MOCK_PORT,
                        "document",
			"chucky",
			"let-me-in",
			"someFileName",
			docInput, 10, 10);
                System.out.println("DHUpload uploadDoc() returned ID: "+returnedId);
		assertEquals("573614a4c8ff93f018892496", returnedId);

		verify(postRequestedFor(urlMatching("/document.*"))
			.withRequestBody(matching(".*<ClinicalDocument xmlns=\"urn:hl7-org:v3\".*"))
			.withHeader("Content-Type", matching("application/xml")));
	}
	
	//@Test
	public void testCloudServer() throws IOException, URISyntaxException, RestClientException
	{
		InputStream docInput = getClass().getResourceAsStream("374117_CCDACCD_20161202.xml");
		DHUpload dhUploader = new DHUpload();
		String returnedId = dhUploader.uploadDoc(
			"https://va-api.diameterhealth.com",
                        "document",
			"REPLACE WHEN TESTING@DOMAIN",
			"REPLACE WHEN TESTING",
			"374117_CCDACCD_20161202.xml",
			docInput, 10, 10);
		System.err.println("Got back doc ID " + returnedId);
	}	
}
