/*
 * US.01.02.07 - Send eHX Files to Diameter Health (DH) and DQ Team Server
 * 
 * Entity class for the DQ_TRANSMISSION_LOG database table, 
 * which stores the Data Quality file upload transmission process log records.
 *
 */
package gov.va.med.nhin.adapter.dataquality.transmissionlog;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;


@Entity
@Table(name = "DQ_TRANSMISSION_LOG")
@NamedQueries({
    @NamedQuery(name = "DqTransmissionLog.findAll", query = "select d from DqTransmissionLog d"),
    @NamedQuery(name = "DqTransmissionLog.findByDqTransmissionId", query = "select d from DqTransmissionLog d where d.dqTransmissionId=:dqTransmissionId"),
    @NamedQuery(name = "DqTransmissionLog.findByBatchId", query = "select d from DqTransmissionLog d where d.batchId=:batchId"),
    @NamedQuery(name = "DqTransmissionLog.findByFilename", query = "select d from DqTransmissionLog d where d.filename=:filename"),
    @NamedQuery(name = "DqTransmissionLog.findByLocalDocId", query = "select d from DqTransmissionLog d where d.localDocId=:localDocId"),
    @NamedQuery(name = "DqTransmissionLog.findByRemoteDocId", query = "select d from DqTransmissionLog d where d.remoteDocId=:remoteDocId")
})
public class DqTransmissionLog implements Serializable {
    
    private static final long serialVersionUID = 1L;
  
    @Id
    @Basic(optional = false)
    @Column(name = "DQ_TRANSMISSION_ID")
    private Long dqTransmissionId;
    
    @Basic(optional = true)
    @Column(name = "BATCH_ID")
    private String batchId;
    
    @Basic(optional = true)
    @Column(name = "EVENT_TYPE")
    private String eventType;    

    @Basic(optional = false)
    @Column(name = "START_TIME")
    @Temporal(TemporalType.TIMESTAMP)
    private Date startTime;

    @Basic(optional = true)
    @Column(name = "END_TIME")
    @Temporal(TemporalType.TIMESTAMP)
    private Date endTime;

    @Basic(optional = true)
    @Column(name = "HOSTNAME")
    private String hostname;
    
    @Basic(optional = true)
    @Column(name = "LOCAL_DOC_ID")
    private String localDocId;     

    @Basic(optional = true)
    @Column(name = "FILENAME")
    private String filename; 
    
    @Basic(optional = true)
    @Column(name = "FILETYPE")
    private String filetype;  

    @Basic(optional = true)
    @Column(name = "FILESIZE")
    private Double filesize;

    @Basic(optional = true)
    @Column(name = "DESTINATION")
    private String destination;    

    @Basic(optional = true)
    @Column(name = "STATUS")
    private String status;    

    @Basic(optional = true)
    @Column(name = "REMOTE_DOC_ID")
    private String remoteDocId;       

    @Basic(optional = true)
    @Column(name = "ERROR")
    private String error;
    

    public DqTransmissionLog() {
    }

    public Long getDqTransmissionId() {
        return this.dqTransmissionId;
    }

    public void setDqTransmissionId(Long dqTransmissionId) {
        this.dqTransmissionId = dqTransmissionId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }   

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public Double getFilesize() {
        return this.filesize;
    }

    public void setFilesize(Double filesize) {
        this.filesize = filesize;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }  
    

    public String getBatchId() {
        return batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public String getEventType() {
        return eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getLocalDocId() {
        return localDocId;
    }

    public void setLocalDocId(String localDocId) {
        this.localDocId = localDocId;
    }

    public String getFiletype() {
        return filetype;
    }

    public void setFiletype(String filetype) {
        this.filetype = filetype;
    }

    public String getRemoteDocId() {
        return remoteDocId;
    }

    public void setRemoteDocId(String remoteDocId) {
        this.remoteDocId = remoteDocId;
    }    
    
    @Override
    public int hashCode()
    {
        int ret = 0;
        ret += (this.dqTransmissionId != null ? this.dqTransmissionId.hashCode() : 0);
        return ret;
    }
        
    @Override
    public boolean equals(Object obj)
    {
        if (!(obj instanceof DqTransmissionLog)) {
            return false;
        }
        DqTransmissionLog dqtl = (DqTransmissionLog)obj;
        if (this != dqtl && (this.dqTransmissionId == null || dqtl.dqTransmissionId == null || !this.dqTransmissionId.equals(dqtl.dqTransmissionId))) {
            return false;
        }
        return true;
    }
        
}
