package gov.va.med.nhin.adapter.dataquality.dh;


import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

import gov.va.med.nhin.adapter.dataquality.common.LogUtil;
import gov.va.med.nhin.adapter.dataquality.common.RestClientException;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status.Family;

import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.ClientProperties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author cbarber
 */
public class DHUpload
{
	//public static final String DOCUMENT_ROUTE = "document";
	private static final Logger LOGGER = LoggerFactory.getLogger(DHUpload.class);

        public String uploadDoc(String urlContext, String path, String user, String key, String filename, byte[] docInput,
              int connectTimeout, int readTimeout) throws RestClientException
        {
            ByteArrayInputStream bais = new ByteArrayInputStream(docInput);
            return uploadDoc(urlContext, path, user, key, filename, bais, connectTimeout, readTimeout);
        }
        
	public String uploadDoc(String urlContext, String path, String user, String key, String filename, InputStream docInput, 
            int connectTimeout, int readTimeout) throws RestClientException
	{
            ClientConfig configuration = new ClientConfig();
            configuration = configuration.property(ClientProperties.CONNECT_TIMEOUT, 1000*connectTimeout);
            configuration = configuration.property(ClientProperties.READ_TIMEOUT, 1000*readTimeout);
            Client client = ClientBuilder.newClient(configuration);
            Entity uploadEnt = Entity.entity(docInput, MediaType.APPLICATION_XML);
            Response response = client.target(urlContext)
                    .path(path)
                    .queryParam("user", user)
                    .queryParam("key", key)
                    .queryParam("filename", filename)
                    .request(MediaType.APPLICATION_JSON_TYPE)
                    .post(uploadEnt, Response.class);

            Response.StatusType status = response.getStatusInfo();
            if(status.getFamily() != Family.SUCCESSFUL)
            {
                    String body = response.readEntity(String.class);
                    //StringBuilder errMsg = new StringBuilder();
                    //errMsg.append("Upload failed with HTTP ")
                    //        .append(status.getStatusCode())
                    //        .append(" ")
                    //        .append(status.getReasonPhrase());
                            // NOTE: Can't append body due to Fortify/cross-site scripting risk
                            //.append("\n")
                            //.append(body);
                    //throw new RuntimeException(errMsg.toString());
                    throw new RestClientException(status.getStatusCode(), body, "Diameter Health service upload returned HTTP error response: "+status.getStatusCode()+" / "+status.getReasonPhrase());
            }
            String _idStr = null;
            try {
                String jsonData = response.readEntity(String.class);

                ObjectMapper objectMapper = new ObjectMapper();
                // throws IOException
                JsonNode rootNode = objectMapper.readTree(jsonData);

                if(null != rootNode) {
                    JsonNode docNode = rootNode.findPath("document");
                    if(null != docNode) {
                        JsonNode _idNode = docNode.findValue("_id");
                        if(null != _idNode) {
                            _idStr = _idNode.asText();
                        }
                    }
                }
                LOGGER.trace("DHUpload POST request returned success HTTP response body: "+jsonData);
            } catch(IOException e) {
                throw new RestClientException(e);
            }            
            LOGGER.debug(LogUtil.cleanLogMessage("Successfully uploaded data filename "+filename+" to DH - received _id: "+_idStr));
            return _idStr;
	}
}
