package gov.va.med.nhin.adapter.dataquality.common;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

import org.slf4j.Logger;

public class DatabaseUtils
{
   public static void closeConnection(Connection conn, Logger logger)
   {
      if(conn == null)
      {
         return;
      }
      
      try
      {
         conn.close();
      }
      catch(SQLException ex)
      {
         if(logger != null)
         {
            logger.warn("An exception occurred while closing a database connection.", ex);
         }
      }
   }
   
   public static void closeStatement(Statement stmt, Logger logger)
   {
      if(stmt == null)
      {
         return;
      }
      
      try
      {
         stmt.close();
      }
      catch(SQLException ex)
      {
         if(logger != null)
         {
            logger.warn("An exception occurred while closing a database statement.", ex);
         }
      }
   }

   public static void closeIO(Closeable toClose, Logger logger)
   {
      if(toClose == null)
      {
         return;
      }
      
      try
      {
         toClose.close();
      }
      catch(IOException ex)
      {
         if(logger != null)
         {
            logger.warn("An exception occurred while closing an IO resource.", ex);
         }
      }
   }
   
    public static void closeBlob(Blob toClose, Logger logger)
   {
      if(toClose == null)
      {
         return;
      }
      
      try
      {
         toClose.free();
      }
      catch(SQLException ex)
      {
         if(logger != null)
         {
            logger.warn("An exception occurred while closing an IO resource.", ex);
         }
      }
   }
}
