package gov.va.med.nhin.adapter.datamanager;

import gov.va.med.nhin.adapter.datamanager.config.ReferenceType;
import gov.va.med.nhin.adapter.datamanager.parsers.JAXBDataParser;
import gov.va.med.nhin.adapter.results.AddressType;
import gov.va.med.nhin.adapter.results.AdverseEventTypeValueType;
import gov.va.med.nhin.adapter.results.AllergiesType;
import gov.va.med.nhin.adapter.results.AllergyType;
import gov.va.med.nhin.adapter.results.AllergyType.Comments;
import gov.va.med.nhin.adapter.results.AllergyType.Comments.Comment;
import gov.va.med.nhin.adapter.results.AllergyType.DrugClasses;
import gov.va.med.nhin.adapter.results.AllergyType.DrugIngredients;
import gov.va.med.nhin.adapter.results.AllergyType.Reactions;
import gov.va.med.nhin.adapter.results.AllergyType.Reactions.Reaction;
import gov.va.med.nhin.adapter.results.AppointmentType;
import gov.va.med.nhin.adapter.results.AppointmentsType;
import gov.va.med.nhin.adapter.results.BooleanValueType;
import gov.va.med.nhin.adapter.results.CodeNameDateType;
import gov.va.med.nhin.adapter.results.CodedValueType;
import gov.va.med.nhin.adapter.results.CommentType;
import gov.va.med.nhin.adapter.results.DocumentReferenceType;
import gov.va.med.nhin.adapter.results.DocumentType;
import gov.va.med.nhin.adapter.results.DocumentType.Clinicians;
import gov.va.med.nhin.adapter.results.DocumentsType;
import gov.va.med.nhin.adapter.results.DoseType;
import gov.va.med.nhin.adapter.results.ExposureType;
import gov.va.med.nhin.adapter.results.FMDateTimeType;
import gov.va.med.nhin.adapter.results.FacilityType;
import gov.va.med.nhin.adapter.results.FactorType;
import gov.va.med.nhin.adapter.results.FactorsType;
import gov.va.med.nhin.adapter.results.FillType;
import gov.va.med.nhin.adapter.results.ImmunizationType;
import gov.va.med.nhin.adapter.results.ImmunizationsType;
import gov.va.med.nhin.adapter.results.InsuranceType;
import gov.va.med.nhin.adapter.results.InsuranceType.Company;
import gov.va.med.nhin.adapter.results.InsurancesType;
import gov.va.med.nhin.adapter.results.IntegerValueType;
import gov.va.med.nhin.adapter.results.LabType;
import gov.va.med.nhin.adapter.results.LabsType;
import gov.va.med.nhin.adapter.results.LocalCodeTypeValueType;
import gov.va.med.nhin.adapter.results.MeasurementType;
import gov.va.med.nhin.adapter.results.MeasurementType.Qualifiers;
import gov.va.med.nhin.adapter.results.MedType;
import gov.va.med.nhin.adapter.results.MedType.Doses;
import gov.va.med.nhin.adapter.results.MedType.Fills;
import gov.va.med.nhin.adapter.results.MedType.Products;
import gov.va.med.nhin.adapter.results.MedicationRoutingValueType;
import gov.va.med.nhin.adapter.results.MedicationStatusValueType;
import gov.va.med.nhin.adapter.results.MedicationTypeValueType;
import gov.va.med.nhin.adapter.results.MedsType;
import gov.va.med.nhin.adapter.results.NumberValueType;
import gov.va.med.nhin.adapter.results.OrderType;
import gov.va.med.nhin.adapter.results.OrderType.Acknowledgements;
import gov.va.med.nhin.adapter.results.OrdersType;
import gov.va.med.nhin.adapter.results.PanelType;
import gov.va.med.nhin.adapter.results.PanelType.Values;
import gov.va.med.nhin.adapter.results.PanelsType;
import gov.va.med.nhin.adapter.results.PatientType;
import gov.va.med.nhin.adapter.results.PatientType.Facilities;
import gov.va.med.nhin.adapter.results.PatientType.Supports;
import gov.va.med.nhin.adapter.results.PatientType.TelecomList;
import gov.va.med.nhin.adapter.results.ProblemAcuityValuesType;
import gov.va.med.nhin.adapter.results.ProblemType;
import gov.va.med.nhin.adapter.results.ProblemTypeValuesType;
import gov.va.med.nhin.adapter.results.ProblemsType;
import gov.va.med.nhin.adapter.results.ProcedureType;
import gov.va.med.nhin.adapter.results.ProceduresType;
import gov.va.med.nhin.adapter.results.ProductType;
import gov.va.med.nhin.adapter.results.ProviderType;
import gov.va.med.nhin.adapter.results.ReasonType;
import gov.va.med.nhin.adapter.results.ReminderType;
import gov.va.med.nhin.adapter.results.RemindersType;
import gov.va.med.nhin.adapter.results.ResultsType;
import gov.va.med.nhin.adapter.results.SourceValueType;
import gov.va.med.nhin.adapter.results.StringValueType;
import gov.va.med.nhin.adapter.results.SupportType;
import gov.va.med.nhin.adapter.results.TelecomType;
import gov.va.med.nhin.adapter.results.VAMedicationStatusValueType;
import gov.va.med.nhin.adapter.results.VAMedicationTypeValueType;
import gov.va.med.nhin.adapter.results.ValueType;
import gov.va.med.nhin.adapter.results.VisitType;
import gov.va.med.nhin.adapter.results.VisitType.Documents;
import gov.va.med.nhin.adapter.results.VisitType.Providers;
import gov.va.med.nhin.adapter.results.VisitsType;
import gov.va.med.nhin.adapter.results.VitalType;
import gov.va.med.nhin.adapter.results.VitalType.Measurements;
import gov.va.med.nhin.adapter.results.VitalsType;
import gov.va.med.nhin.adapter.utils.config.PropertiesType;
import gov.va.med.nhin.adapter.utils.config.PropertyType;
import gov.va.med.nhin.adapter.xmlutils.XMLTemplate;
import gov.va.med.nhin.adapter.xmlutils.XMLTemplateFactory;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.commons.lang.NumberUtils;
import org.apache.commons.lang.RandomStringUtils;

public class Generate {

	private static final Level FINEST = null;

	static AddressType createAddressType() {
		AddressType addressType = new AddressType();

		addressType.setCity(RandomStringUtils.randomAlphabetic(10));
		addressType.setPostalCode(RandomStringUtils.randomNumeric(5));
		addressType.setStateProvince(RandomStringUtils.randomAlphabetic(2));
		addressType.setStreetLine1(RandomStringUtils.randomAlphabetic(5));
		addressType.setStreetLine2(RandomStringUtils.randomAlphabetic(5));
		addressType.setStreetLine3(RandomStringUtils.randomAlphabetic(5));

		return addressType;
	}

	//
	// ImmunizationsType

	static ImmunizationsType createImmunizationsType() {
		ImmunizationsType immunizationsType = new ImmunizationsType();

		for (int ctr = 0; ctr < 1; ctr++) {
			immunizationsType.getImmunization().add(createImmunizationType());
		}

		return immunizationsType;
	}

	static VitalsType createVitalsType() {
		VitalsType vitalsType = new VitalsType();

		for (int ctr = 0; ctr < 1; ctr++) {
			vitalsType.getVital().add(createVitalType());
		}

		return vitalsType;
	}

	/**
	 * @return
	 */
	private static VitalType createVitalType() {
		VitalType vitalType = new VitalType();
		vitalType.setEntered(createFMDateTimeType());
		vitalType.setFacility(createFacilityType());
		vitalType.setMeasurements(createMeasurements());
		vitalType.setTaken(createFMDateTimeType());

//		vitalType.setEnteredTime(vitalType.getEntered());

		StringValueType svt = new StringValueType();
		svt.setValue(vitalType.getFacility().getName());
//		vitalType.setFacilityName(svt);

		svt = new StringValueType();
		svt.setValue(vitalType.getFacility().getCode());
//		vitalType.setFacilityNumber(svt);

//		vitalType.setTakenTime(vitalType.getTaken());

		return vitalType;
	}

	/**
	 * @return
	 */
	private static Measurements createMeasurements() {
		Measurements measurements = new Measurements();

		for (int ctr = 0; ctr < 1; ctr++) {
			measurements.getMeasurement().add(createMeasurementType());

		}

		return measurements;
	}

	/**
	 * @return
	 */
	private static MeasurementType createMeasurementType() {
		MeasurementType measurementType = new MeasurementType();
		measurementType.setHigh(RandomStringUtils.randomNumeric(5));
		measurementType.setId(RandomStringUtils.randomNumeric(5));
		measurementType.setLow(RandomStringUtils.randomNumeric(5));
		measurementType.setMetricUnits(RandomStringUtils.randomNumeric(5));
		measurementType.setMetricValue(RandomStringUtils.randomNumeric(5));
		measurementType.setName(RandomStringUtils.randomAlphanumeric(5));
		measurementType.setQualifiers(createQualifiers());
		measurementType.setUnits(RandomStringUtils.randomNumeric(5));
		measurementType.setValue(RandomStringUtils.randomNumeric(5));
		measurementType.setVuid(RandomStringUtils.randomNumeric(5));
//		measurementType.setUnit(RandomStringUtils.randomNumeric(5));
//		measurementType.setVitalCode(RandomStringUtils.randomNumeric(5));
//		measurementType.setVitalDisplay(RandomStringUtils.randomAlphanumeric(5));
//		measurementType.setVitalID(RandomStringUtils.randomAlphanumeric(5));

		return measurementType;
	}

	/**
	 * @return
	 */
	private static Qualifiers createQualifiers() {
		Qualifiers qualifiers = new Qualifiers();
		for (int ctr = 0; ctr < 1; ctr++) {
			qualifiers.getQualifier().add(createCodedValueType());

		}
		return qualifiers;
	}

	/**
	 * @return
	 */
	private static ImmunizationType createImmunizationType() {
		ImmunizationType immunizationType = new ImmunizationType();
		immunizationType.setAdministered(createFMDateTimeType());
		immunizationType.setComment(createStringValueType());
		immunizationType.setContraindicated(createStringValueType());
		immunizationType.setCpt(createCodedValueType());
		immunizationType.setFacility(createCodedValueType());
		immunizationType.setId(createStringValueType());
		immunizationType.setLocation(createStringValueType());
		immunizationType.setName(createStringValueType());
		immunizationType.setProvider(createCodedValueType());
		immunizationType.setReaction(createStringValueType());

		StringValueType seriesValue = new StringValueType();

		seriesValue.setValue(RandomStringUtils.randomNumeric(1));

		immunizationType.setSeries(seriesValue);

//		immunizationType.setSeriesNumber(immunizationType.getSeries());
//		immunizationType.setAdminDate(createFMDateTimeType());

		StringValueType svt = new StringValueType();
		svt.setValue(immunizationType.getCpt().getCode());

//		immunizationType.setCptCode(svt);
		svt = new StringValueType();
		svt.setValue(immunizationType.getCpt().getName());

//		immunizationType.setCptDisplay(svt);
		svt = new StringValueType();
		svt.setValue(immunizationType.getProvider().getCode());
//		immunizationType.setProviderID(svt);
		svt = new StringValueType();
		svt.setValue(immunizationType.getProvider().getName());
//		immunizationType.setProviderName(svt);

		svt = new StringValueType();
		svt.setValue(immunizationType.getFacility().getName());
//		immunizationType.setFacilityName(svt);

		svt = new StringValueType();
		svt.setValue(immunizationType.getFacility().getCode());
//		immunizationType.setFacilityNumber(svt);

		return immunizationType;

	}

	static AllergiesType createAllergiesTypes(boolean noKnown) {
		AllergiesType allergiesType = new AllergiesType();

		for (int ctr = 0; ctr < 5; ctr++) {
			allergiesType.getAllergy().add(createAllergyType(noKnown));
		}

		allergiesType.getAllergy().add(createAllergyType(!noKnown));

		return allergiesType;
	}

	static AllergyType createAllergyType(boolean noKnown) {
		AllergyType allergyType = new AllergyType();

		if (noKnown) {
			StringValueType assessment = new StringValueType();
			assessment.setValue("nka");
//			allergyType.setAssessment(assessment);
		}

		AdverseEventTypeValueType value1 = new AdverseEventTypeValueType();
		value1.setValue(RandomStringUtils.randomNumeric(5));
		allergyType.setAdverseEventType(value1);
		Comments value2 = new Comments();
		;
		Comment comment = new Comment();
		comment.setCommentText(RandomStringUtils.randomAlphabetic(25));
		comment.setCommentType(RandomStringUtils.randomNumeric(5));

		comment.setEntered(NumberUtils.createBigDecimal(RandomStringUtils.randomNumeric(10)));
		comment.setEnteredBy(RandomStringUtils.randomAlphabetic(10));
		comment.setId(NumberUtils.createBigInteger(RandomStringUtils.randomNumeric(10)).longValue());
		value2.getComment().add(comment);
		allergyType.setComments(value2);
		DrugClasses value3 = new DrugClasses();

		value3.getDrugClass().add(createCodedValueType());

		value3.getDrugClass().add(createCodedValueType());

		value3.getDrugClass().add(createCodedValueType());

		value3.getDrugClass().add(createCodedValueType());

		allergyType.setDrugClasses(value3);

		DrugIngredients value4 = new DrugIngredients();

		value4.getDrugIngredient().add(createCodedValueType());

		value4.getDrugIngredient().add(createCodedValueType());

		value4.getDrugIngredient().add(createCodedValueType());

		value4.getDrugIngredient().add(createCodedValueType());

		allergyType.setDrugIngredients(value4);

		allergyType.setEntered(createFMDateTimeType());

		allergyType.setFacility(createFacilityType());

		allergyType.setId(createNumberValueType());

		allergyType.setLocalCode(createStringValueType());
		LocalCodeTypeValueType value9 = new LocalCodeTypeValueType();
		value9.setValue("localCodeType");
		allergyType.setLocalCodeType(value9);

		allergyType.setName(createStringValueType());
		Reactions value11 = new Reactions();

		Reaction e = new Reaction();
		e.setCode(RandomStringUtils.randomNumeric(5));
		e.setName(RandomStringUtils.randomAlphabetic(5));
		e.setVuid(RandomStringUtils.randomNumeric(5));
		value11.getReaction().add(e);
		e = new Reaction();
		e.setCode(RandomStringUtils.randomNumeric(5));
		e.setName(RandomStringUtils.randomAlphabetic(5));
		e.setVuid(RandomStringUtils.randomNumeric(5));
		value11.getReaction().add(e);
		e = new Reaction();
		e.setCode(RandomStringUtils.randomNumeric(5));
		e.setName(RandomStringUtils.randomAlphabetic(5));
		e.setVuid(RandomStringUtils.randomNumeric(5));
		value11.getReaction().add(e);
		e = new Reaction();
		e.setCode(RandomStringUtils.randomNumeric(5));
		e.setName(RandomStringUtils.randomAlphabetic(5));
		e.setVuid(RandomStringUtils.randomNumeric(5));

		value11.getReaction().add(e);
		allergyType.setReactions(value11);

		allergyType.setSeverity(createStringValueType());
		SourceValueType value13 = new SourceValueType();
		value13.setValue(RandomStringUtils.randomNumeric(5));

		allergyType.setSource(value13);

		allergyType.setType(createCodedValueType());

		allergyType.setVerified(createFMDateTimeType());

		allergyType.setVuid(createStringValueType());

//		allergyType.setAdverseTypeCode(createStringValueType());

//		allergyType.setProductTextName(createStringValueType());

//		allergyType.setStartDate(allergyType.getVerified());
//		allergyType.setProductTextNameCoded(createStringValueType());

		StringValueType svt = new StringValueType();
		svt.setValue(allergyType.getFacility().getName());
//		allergyType.setFacilityName(svt);
		svt = new StringValueType();
		svt.setValue(allergyType.getFacility().getCode());
//		allergyType.setFacilityNumber(svt);

//		allergyType.setAdverseTypeDisplay(createStringValueType());

		return allergyType;
	}

	private static BooleanValueType createBooleanValueType() {
		BooleanValueType booleanValueType = new BooleanValueType();

		booleanValueType.setValue(false);

		return booleanValueType;
	}

	private static CodedValueType createCodedValueType() {
		CodedValueType codedValueType = new CodedValueType();
		codedValueType.setCode(RandomStringUtils.randomNumeric(10));
		codedValueType.setName(RandomStringUtils.randomAlphabetic(20));
		codedValueType.setVuid(RandomStringUtils.randomNumeric(10));
		return codedValueType;
	}

	private static CommentType createComment() {
		CommentType comment = new CommentType();
		comment.setCommentText(RandomStringUtils.randomAlphabetic(20));
		comment.setEntered("100");
		comment.setEnteredBy(RandomStringUtils.randomAlphabetic(10));
		comment.setCode(NumberUtils.createBigDecimal(RandomStringUtils.randomNumeric(10)));
		NumberUtils.createBigDecimal(RandomStringUtils.randomNumeric(10));

		return comment;
	}

	private static gov.va.med.nhin.adapter.results.ProblemType.Comments createComments() {

		gov.va.med.nhin.adapter.results.ProblemType.Comments comments = new gov.va.med.nhin.adapter.results.ProblemType.Comments();
		;

		for (int i = 0; i < 1; i++) {
			comments.getComment().add(createComment());
		}

		return comments;
	}

	private static DoseType createDose() {
		DoseType dt = new DoseType();
		dt.setConjunction(RandomStringUtils.randomAlphabetic(5));
		dt.setDose(RandomStringUtils.randomNumeric(2));
		dt.setDoseStart(NumberUtils.createBigDecimal(RandomStringUtils.randomNumeric(10)));
		dt.setDoseStop(NumberUtils.createBigDecimal(RandomStringUtils.randomNumeric(10)));
		dt.setDuration(RandomStringUtils.randomNumeric(2));
		dt.setFillerInfo(RandomStringUtils.randomAlphabetic(5));
		dt.setNoun(RandomStringUtils.randomAlphabetic(5));
		dt.setPlacerInfo(RandomStringUtils.randomAlphabetic(5));
		dt.setRoute(RandomStringUtils.randomAlphabetic(5));
		dt.setSchedule(RandomStringUtils.randomAlphabetic(5));
		dt.setUnits(RandomStringUtils.randomNumeric(1));
		dt.setUnitsPerDose(RandomStringUtils.randomNumeric(1));
		return dt;
	}

	private static Doses createDoses() {
		Doses doses = new Doses();

		for (int i = 0; i < 1; i++) {
			doses.getDose().add(createDose());
		}

		return doses;
	}

	static gov.va.med.nhin.adapter.results.ProblemType.Exposures createExposures() {
		gov.va.med.nhin.adapter.results.ProblemType.Exposures exposures = new gov.va.med.nhin.adapter.results.ProblemType.Exposures();

		for (int i = 0; i < 1; i++) {
			exposures.getExposure().add(createExposureType());
		}

		return exposures;
	}

	static ExposureType createExposureType() {
		ExposureType exposureType = new ExposureType();

		exposureType.setValue(RandomStringUtils.randomAlphabetic(5));

		return exposureType;
	}

	static Facilities createFacilities() {
		Facilities facilities = new Facilities();

		for (int i = 0; i < 1; i++) {
			facilities.getFacility().add(createFacilityType());
		}

		return facilities;
	}

	private static FacilityType createFacilityType() {
		FacilityType facilityType = new FacilityType();
		facilityType.setCode(RandomStringUtils.randomNumeric(10));
		facilityType.setHomeSite(RandomStringUtils.randomNumeric(10));
		facilityType.setLatestDate(NumberUtils.createBigDecimal(RandomStringUtils.randomNumeric(10)));
		facilityType.setName(RandomStringUtils.randomAlphabetic(10));
		facilityType.setVuid(RandomStringUtils.randomNumeric(10));
		return facilityType;
	}

	private static Fills createFills() {
		Fills fills = new Fills();

		for (int i = 0; i < 1; i++) {
			fills.getFill().add(createFillType());
		}

		return fills;
	}

	private static FillType createFillType() {
		FillType fillType = new FillType();
		fillType.setFillDate(NumberUtils.createBigDecimal(RandomStringUtils.randomNumeric(10)));
		fillType.setFillDaysSupply(NumberUtils.createBigInteger(RandomStringUtils.randomNumeric(2)));
		fillType.setFillQuantity(NumberUtils.createBigDecimal(RandomStringUtils.randomNumeric(2)));
		fillType.setFillRouting(RandomStringUtils.randomAlphabetic(5));
		fillType.setPartial(Boolean.FALSE);
		fillType.setReleaseDate(NumberUtils.createBigDecimal(RandomStringUtils.randomNumeric(10)));

		return fillType;
	}

	static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");

	private static FMDateTimeType createFMDateTimeType() {
		FMDateTimeType fMDateTimeType = new FMDateTimeType();

		fMDateTimeType.setValue(NumberUtils.createBigDecimal(DATE_FORMAT.format(new Date(
			Math.abs(System.currentTimeMillis() - Long.valueOf(RandomStringUtils.randomNumeric(10)).longValue())))));
		return fMDateTimeType;
	}

	private static IntegerValueType createIntegerValueType() {
		IntegerValueType integerValueType = new IntegerValueType();
		integerValueType.setValue(BigInteger.valueOf(1234));
		return integerValueType;
	}

	private static LabsType createLabsType() {
		LabsType labsType = new LabsType();

		for (int ctr = 0; ctr < 1; ctr++) {
			labsType.getLab().add(createLabType());
		}

		return labsType;

	}

	private static LabType createLabType() {
		LabType labType = new LabType();

		labType.setCode(createStringValueType());
		labType.setCollected(createFMDateTimeType());
		labType.setComment(RandomStringUtils.randomAlphabetic(10));
		labType.setFacility(createFacilityType());
		labType.setGroupID(createStringValueType());
		labType.setHigh(createStringValueType());
		labType.setId(createStringValueType());
		labType.setInterpretation(createStringValueType());
		labType.setLabOrderID(createNumberValueType());
		labType.setLocalName(createStringValueType());
		labType.setLoinc(createStringValueType());
		labType.setLow(createStringValueType());
		labType.setOrderID(createStringValueType());
		labType.setReport(createNumberValueType());
		labType.setResult(createStringValueType());
		labType.setResulted(createFMDateTimeType());
		labType.setSample(createStringValueType());
		labType.setSpecimen(createStringValueType());
		labType.setStatus(createStringValueType());
		labType.setTest(createStringValueType());
		labType.setType(createStringValueType());
		labType.setUnits(createStringValueType());
//		Order order = new Order();
//		order.setCode(createStringValueType());
//		order.setName(createStringValueType());
//		labType.setOrder(order);

//		gov.va.med.nhin.adapter.results.LabType.Values value;
//		labType.setValues(createLabValues());

		return labType;

	}

	/**
	 * @return
	 */
//	private static gov.va.med.nhin.adapter.results.LabType.Values createLabValues() {
//		gov.va.med.nhin.adapter.results.LabType.Values values = new gov.va.med.nhin.adapter.results.LabType.Values();
//
//		for (int ctr = 0; ctr < 1; ctr++) {
//			ValueType e;
//			values.getValue().add(createValueType());
//		}
//
//		return values;
//	}

	static MedsType createMedsTypes() {
		MedsType medsType = new MedsType();

		for (int ctr = 0; ctr < 1; ctr++) {
			medsType.getMed().add(createMedType());
		}

		return medsType;
	}

	private static MedType createMedType() {
		MedType medType = new MedType();

		medType.setClazz(createStringValueType());

		medType.setCurrentProvider(createCodedValueType());

		medType.setDaysSupply(createIntegerValueType());

		medType.setDoses(createDoses());

		medType.setExpires(createFMDateTimeType());

		medType.setFacility(createFacilityType());

		medType.setFillCost(createNumberValueType());

		medType.setFills(createFills());

		medType.setFillsAllowed(createIntegerValueType());

		medType.setFillsRemaining(createIntegerValueType());

		medType.setForm(createStringValueType());

		medType.setId(createStringValueType());

		medType.setInstructions(createStringValueType());

		medType.setLastFilled(createFMDateTimeType());

		medType.setLocation(createCodedValueType());

		medType.setName(createStringValueType());

		medType.setOrdered(createFMDateTimeType());

		medType.setOrderID(createStringValueType());

		medType.setOrderingProvider(createCodedValueType());

		medType.setPharmacist(createCodedValueType());

		medType.setPrescription(createStringValueType());

		medType.setProducts(createProducts());

		medType.setPtInstructions(createStringValueType());

		medType.setQuantity(createNumberValueType());
		MedicationRoutingValueType valueR = new MedicationRoutingValueType();
		;

		valueR.setValue(RandomStringUtils.randomAlphabetic(5));

		medType.setRouting(valueR);

		medType.setSig(RandomStringUtils.randomAlphabetic(25));

		medType.setStart(createFMDateTimeType());

		MedicationStatusValueType valueU = new MedicationStatusValueType();
		;
		valueU.setValue(RandomStringUtils.randomNumeric(5));
		medType.setStatus(valueU);

		medType.setStop(createFMDateTimeType());
		MedicationTypeValueType valueX = new MedicationTypeValueType();
		;
		valueX.setValue(RandomStringUtils.randomNumeric(5));
		medType.setType(valueX);
		VAMedicationStatusValueType valueY = new VAMedicationStatusValueType();
		;
		valueY.setValue(RandomStringUtils.randomNumeric(5));
		medType.setVaStatus(valueY);

		VAMedicationTypeValueType valueZ = new VAMedicationTypeValueType();
		;

		valueZ.setValue(RandomStringUtils.randomNumeric(5));
		medType.setVaType(valueZ);

//		medType.setOrderDate(createFMDateTimeType());

		for (ProductType product : medType.getProducts().getProduct()) {

			if ("D".equals(product.getRole())) {
				StringValueType stringValueType = new StringValueType();
				stringValueType.setValue(product.getName());
//				medType.setProdNameText(stringValueType);
			}
		}

		StringValueType sv = new StringValueType();
		sv.setValue(medType.getFacility().getName());
//		medType.setFacilityName(sv);
		sv = new StringValueType();
		sv.setValue(medType.getFacility().getCode());

//		medType.setFacilityNumber(sv);

//		medType.setTypeCode(createStringValueType());
//		medType.setTypeDisplay(createStringValueType());
//		medType.setExpireDate(medType.getExpires().toString());
//		medType.setOrderProviderName(medType.getOrderingProvider().getName());
//		medType.setPrescriptId(medType.getPrescription().getValue());
//
//		medType.setDispenseTime(medType.getLastFilled().toString());

		return medType;
	}

	private static NumberValueType createNumberValueType() {
		NumberValueType numberValueType = new NumberValueType();
		numberValueType.setValue(BigDecimal.valueOf(123.12));
		return numberValueType;
	}

	private static PanelsType createPanelsType() {
		PanelsType panelsType = new PanelsType();

		for (int ctr = 0; ctr < 1; ctr++) {
			panelsType.getPanel().add(createPanelType());
		}

		return panelsType;

	}

	private static PanelType createPanelType() {
		PanelType panelType = new PanelType();

		panelType.setCollected(createFMDateTimeType());
		panelType.setComment("comment");
		panelType.setFacility(createFacilityType());
		panelType.setGroupName(createStringValueType());
		panelType.setId(createStringValueType());
		panelType.setOrder(createCodedValueType());
		panelType.setResulted(createFMDateTimeType());
		panelType.setSample(createStringValueType());
		panelType.setStatus(createStringValueType());
		panelType.setSpecimen(createCodedValueType());
		panelType.setType(createStringValueType());

		panelType.setValues(createValues());

		return panelType;
	}

	static PatientType createPatientType() {
		PatientType patientType = new PatientType();
		patientType.setAddress(createAddressType());
		patientType.setBid(createStringValueType());
		patientType.setDob(createFMDateTimeType());
		patientType.setFacilities(createFacilities());
		patientType.setFamilyName(createStringValueType());
		patientType.setFullName(createStringValueType());
		patientType.setGender(createStringValueType());
		patientType.setGivenNames(createStringValueType());
		patientType.setIcn(createStringValueType());
		patientType.setId(createStringValueType());
		patientType.setLrdfn(createStringValueType());
		patientType.setMaritalStatus(createStringValueType());
		patientType.setSc(createStringValueType());
		patientType.setSsn(createStringValueType());
		patientType.setSupports(createSupports());
		patientType.setTelecomList(createTelecomList());
		patientType.setVeteran(createStringValueType());

//		patientType.setNamePrefix(createStringValueType());
//		patientType.setNameGiven(createStringValueType());
//		patientType.setNameFamily(createStringValueType());
//		patientType.setNameSuffix(createStringValueType());
//		patientType.setGenderCode(createStringValueType());
//		patientType.setBirthDate(createStringValueType());
//		patientType.setRaceDisplay(createStringValueType());
//		patientType.setEthnicityDisplay(createStringValueType());

		return patientType;
	}

	static private ProblemAcuityValuesType createProblemAcuityValuesType() {
		ProblemAcuityValuesType problemAcuityValuesType = new ProblemAcuityValuesType();
		problemAcuityValuesType.setValue("problemAcuityValuesType");
		return problemAcuityValuesType;
	}

	static gov.va.med.nhin.adapter.results.ProblemHistoryValuesType createProblemHistoryValuesType() {
		gov.va.med.nhin.adapter.results.ProblemHistoryValuesType problemHistoryValuesType = new gov.va.med.nhin.adapter.results.ProblemHistoryValuesType();

		problemHistoryValuesType.setValue("PROBLEMHISTORYVALUESTYPE");

		return problemHistoryValuesType;
	}

	static ProblemsType createProblemsType() {
		ProblemsType problemsType = new ProblemsType();

		for (int i = 0; i < 1; i++) {
			problemsType.getProblem().add(createProblemType());
		}

		return problemsType;
	}

	static ProblemType createProblemType() {
		ProblemType problemType = new ProblemType();

		problemType.setAcuity(createProblemAcuityValuesType());
		problemType.setCode(createStringValueType());

		problemType.setComments(createComments());
		problemType.setEntered(createFMDateTimeType());
		problemType.setExposures(createExposures());
		problemType.setFacility(createFacilityType());
		problemType.setHistory(createProblemHistoryValuesType());
		problemType.setIcd(createStringValueType());
		problemType.setId(createStringValueType());
		problemType.setLocation(createStringValueType());
		problemType.setName(createStringValueType());
		problemType.setOnset(createFMDateTimeType());
		problemType.setPredecessor(createNumberValueType());
		problemType.setProblemType(createProblemTypeValuesType());
		problemType.setProvider(createCodedValueType());
		problemType.setResolved(createFMDateTimeType());
		problemType.setSc(createBooleanValueType());
		problemType.setService(createStringValueType());
		problemType.setStatus(createCodedValueType());
		problemType.setStatusName(createStringValueType());
		problemType.setSuccessor(createNumberValueType());
		problemType.setUnverified(createBooleanValueType());
		problemType.setUpdated(createFMDateTimeType());
		;

		problemType.getFacility().getCode();

		StringValueType sv = new StringValueType();
		sv.setValue(problemType.getFacility().getName());
//		problemType.setFacilityName(sv);
		sv = new StringValueType();
		sv.setValue(problemType.getFacility().getCode());

//		problemType.setFacilityNumber(sv);
//		problemType.setDate(problemType.getOnset());
//		problemType.setDateResolved(problemType.getResolved());
//		problemType.setStatusCode(createStringValueType());
//		problemType.setIcdCode(createStringValueType());
//
//		problemType.setStatusDisplay(createStringValueType());

		return problemType;
	}

	static ProblemTypeValuesType createProblemTypeValuesType() {
		ProblemTypeValuesType problemTypeValuesType = new ProblemTypeValuesType();

		problemTypeValuesType.setValue("PROBLEMTYPEVALUESTYPE");

		return problemTypeValuesType;
	}

	private static Products createProducts() {
		Products products = new Products();

		for (int i = 0; i < 1; i++) {
			products.getProduct().add(createProductType(i == 0));
		}

		return products;
	}

	private static ProductType createProductType(boolean isD) {
		ProductType productType = new ProductType();
		productType.setClazz(createCodedValueType());
		productType.setCode(RandomStringUtils.randomAlphabetic(10));
		productType.setName(RandomStringUtils.randomAlphabetic(10));
		productType.setRole(isD
				? "D"
				: "X");
		productType.setVaGeneric(createCodedValueType());
		productType.setVuid(RandomStringUtils.randomAlphabetic(10));

		return productType;
	}

	private static StringValueType createStringValueType() {
		StringValueType stringValueType = new StringValueType();

		stringValueType.setValue(RandomStringUtils.randomAlphabetic(10));
		return stringValueType;
	}

	private static String createString() {
		return (RandomStringUtils.randomAlphabetic(10));
	}

	static Supports createSupports() {
		Supports supports = new Supports();

		for (int i = 0; i < 1; i++) {
			supports.getSupport().add(createSupportType());
		}

		return supports;

	}

	static gov.va.med.nhin.adapter.results.SupportType.TelecomList createSupportTelecomList() {
		gov.va.med.nhin.adapter.results.SupportType.TelecomList telecomList = new gov.va.med.nhin.adapter.results.SupportType.TelecomList();

		for (int i = 0; i < 1; i++) {
			telecomList.getTelecom().add(createTelecomType());
		}

		return telecomList;
	}

	static SupportType createSupportType() {
		SupportType supportType = new SupportType();

		supportType.setAddress(createAddressType());
		supportType.setContactType(RandomStringUtils.randomAlphabetic(10));
		supportType.setName(RandomStringUtils.randomAlphabetic(10));
		supportType.setRelationship(RandomStringUtils.randomAlphabetic(10));

		supportType.setTelecomList(createSupportTelecomList());

		return supportType;
	}

	static TelecomList createTelecomList() {
		TelecomList telecomList = new TelecomList();

		for (int i = 0; i < 1; i++) {
			telecomList.getTelecom().add(createTelecomType());
		}

		return telecomList;
	}

	static TelecomType createTelecomType() {
		TelecomType telecomType = new TelecomType();
		telecomType.setUsageType(RandomStringUtils.randomAlphabetic(10));
		telecomType.setValue(RandomStringUtils.randomAlphabetic(10));
		return telecomType;
	}

	private static Values createValues() {
		Values values = new Values();

		for (int i = 0; i < 1; i++) {
			values.getValue().add(createValueType());
		}

		return values;
	}

	private static ValueType createValueType() {
		ValueType valueType = new ValueType();
		valueType.setHigh(RandomStringUtils.randomAlphabetic(10));
		valueType.setId(RandomStringUtils.randomAlphabetic(10));
		valueType.setInterpretation(RandomStringUtils.randomAlphabetic(10));
		valueType.setLoinc(RandomStringUtils.randomAlphabetic(10));
		valueType.setLow(RandomStringUtils.randomAlphabetic(10));
		valueType.setResult(RandomStringUtils.randomAlphabetic(10));
		valueType.setTest(RandomStringUtils.randomAlphabetic(10));
		valueType.setUnits(RandomStringUtils.randomAlphabetic(10));
		valueType.setVuid(RandomStringUtils.randomAlphabetic(10));
//		valueType.setRange(RandomStringUtils.randomAlphabetic(10));
//		valueType.setLoincDisplay(RandomStringUtils.randomAlphabetic(10));
		return valueType;
	}

	private static ProceduresType createProceduresType(String category) {
		ProceduresType proceduresType = new ProceduresType();

		for (int i = 0; i < 1; i++) {
			proceduresType.getProcedure().add(createProcedureType(category));
		}

		return proceduresType;
	}

	private static ProcedureType.Documents createProcedureTypeDocuments() {
		ProcedureType.Documents procedureTypeDocuments = new ProcedureType.Documents();

		procedureTypeDocuments.getDocument().add(createDocumentReferenceType());
		return procedureTypeDocuments;
	}

	private static DocumentReferenceType createDocumentReferenceType() {
		DocumentReferenceType documentReferenceType = new DocumentReferenceType();
		documentReferenceType.setId(RandomStringUtils.randomAlphabetic(10));
		documentReferenceType.setLocalTitle(RandomStringUtils.randomAlphabetic(10));
		documentReferenceType.setNationalTitle(RandomStringUtils.randomAlphabetic(10));
//		documentReferenceType.setContent(createStringValueType());

		return documentReferenceType;
	}

	private static ProcedureType.Modifiers createProcedureTypeModifiers() {
		ProcedureType.Modifiers procedureTypeModifiers = new ProcedureType.Modifiers();

		for (int i = 0; i < 1; i++) {
			procedureTypeModifiers.getModifier().add(createCodedValueType());
		}

		return procedureTypeModifiers;
	}

	private static ProcedureType.OtherProcedures createProcedureTypeOtherProcedures() {
		ProcedureType.OtherProcedures procedureTypeOtherProcedures = new ProcedureType.OtherProcedures();

		for (int i = 0; i < 1; i++) {
			procedureTypeOtherProcedures.getOtherProcedure().add(createCodedValueType());
		}

		return procedureTypeOtherProcedures;
	}

	private static ProviderType createProviderType(boolean isS) {
		ProviderType providerType = new ProviderType();

		providerType.setCode(RandomStringUtils.randomAlphabetic(10));
		providerType.setDateTime(BigDecimal.valueOf(1234));
		providerType.setName(RandomStringUtils.randomAlphabetic(10));
		providerType.setPrimary(RandomStringUtils.randomAlphabetic(10));
		providerType.setSignature(RandomStringUtils.randomAlphabetic(10));
		if (isS) {
			providerType.setRole("S");

		} else {
			providerType.setRole("X");

		}

		providerType.setVuid(RandomStringUtils.randomAlphabetic(10));

		return providerType;
	}

	private static ProcedureType createProcedureType(String c) {
		ProcedureType procedureType = new ProcedureType();

		procedureType.setCase(createNumberValueType());
		StringValueType category = new StringValueType();

		if (c != null) {
			category.setValue(c);
		} else {
			category.setValue(Long.valueOf(RandomStringUtils.randomNumeric(10)) % 2 == 0
					? "RA"
					: "SR");
		}

		procedureType.setCategory(category);
		procedureType.setDateTime(createFMDateTimeType());
		procedureType.setDocuments(createProcedureTypeDocuments());
		procedureType.setEncounter(createStringValueType());
		procedureType.setFacility(createFacilityType());
		procedureType.setHasImages(createStringValueType());
		procedureType.setId(createStringValueType());
		procedureType.setImagingType(createCodedValueType());
		procedureType.setInterpretation(createStringValueType());
		procedureType.setLocation(createCodedValueType());
		procedureType.setModifiers(createProcedureTypeModifiers());
		procedureType.setName(createStringValueType());
		procedureType.setOpReport(createDocumentReferenceType());
		procedureType.setOtherProcedures(createProcedureTypeOtherProcedures());
		procedureType.setProvider(createProviderType(false));
		procedureType.setStatus(createStringValueType());
		procedureType.setType(createCodedValueType());

		return procedureType;
	}

	private static DocumentsType createDocumentsType() {
		DocumentsType documentsType = new DocumentsType();

		for (int i = 0; i < 1; i++) {
			documentsType.getDocument().add(createDocumentType());
		}

		return documentsType;
	}

	private static Clinicians createClinicians() {
		Clinicians clinicians = new Clinicians();

		for (int i = 0; i < 1; i++) {
			clinicians.getClinician().add(createProviderType(i == 0));
		}

		return clinicians;
	}

	private static DocumentType createDocumentType() {
		DocumentType documentType = new DocumentType();
		Clinicians value;
		documentType.setClinicians(createClinicians());
		documentType.setContent("content");
		documentType.setDocumentClass(createStringValueType());
		documentType.setEncounter(createStringValueType());
		documentType.setFacility(createFacilityType());

		documentType.setLocalTitle(createStringValueType());
		documentType.setLoinc(createStringValueType());
		documentType.setNationalTitle(createCodedValueType());
		documentType.setNationalTitleSubject(createCodedValueType());
		documentType.setNationalTitleType(createCodedValueType());
		documentType.setReferenceDateTime(createFMDateTimeType());
		documentType.setStatus(createStringValueType());
		documentType.setType(createStringValueType());
//		documentType.setReference(createStringValueType());
		StringValueType stringValueType = new StringValueType();

		stringValueType.setValue(documentType.getClinicians().getClinician().get(0).getSignature());

//		documentType.setSignName(stringValueType);
		return documentType;
	}

	/*
	 * Lifted from GUAVA
	 */
	public static String getFileExtension(String fileName) {

		int dotIndex = fileName.lastIndexOf('.');
		return (dotIndex == -1)
				? ""
				: fileName.substring(dotIndex + 1);
	}

	public static String getNameWithoutExtension(String fileName) {

		int dotIndex = fileName.lastIndexOf('.');
		return (dotIndex == -1)
				? fileName
				: fileName.substring(0, dotIndex);
	}

	static String readFile(String fileName) throws IOException {
		BufferedReader br = new BufferedReader(new FileReader(fileName));
		try {
			StringBuilder sb = new StringBuilder();
			String line = br.readLine();

			while (line != null) {
				sb.append(line);
				sb.append("\n");
				line = br.readLine();
			}
			return sb.toString();
		} finally {
			br.close();
		}
	}

	private static String getReturnProperty(String extractName) {

		if ("allergies".equals(extractName)) {
			return "results[0].allergy";
		}

		if ("documents".equals(extractName)) {
			return "results[0].document";
		}

		if ("medications".equals(extractName)) {
			return "results[0].med";
		}

		return "";

	}

	private static void parseAndFillIn(File scenario) throws Exception {

		String location = "results" + System.getProperty("file.separator") + scenario.getName() +
				System.currentTimeMillis() / 1000;

		File theDir = new File("results"); // Defining Directory/Folder Name

		if (!theDir.exists()) { // Checks that Directory/Folder Doesn't Exists!
			boolean result = theDir.mkdir();
		}

		java.util.logging.LogManager.getLogManager().reset();

		Enumeration<String> names = java.util.logging.LogManager.getLogManager().getLoggerNames();

		Handler handler = new FileHandler(location + ".log");
		;

		while (names.hasMoreElements()) {
			String loggerName = names.nextElement();

			java.util.logging.LogManager.getLogManager().getLogger(loggerName).addHandler(handler);
			java.util.logging.LogManager.getLogManager().getLogger(loggerName).setLevel(FINEST);

		}

		XMLTemplate xmlTemplate = XMLTemplateFactory.getXMLTemplate("cccd-mapping.xml");

		File[] files = scenario.listFiles(new FileFilter() {
			public boolean accept(File file) {

				return file.isFile() && getFileExtension(file.getName()).equalsIgnoreCase("XML");
			}
		});

		MappedDataProxy mdp = new MappedDataProxy();

		mdp.setObject(new java.util.HashMap());

		for (File file : files) {
			if (file.isFile()) {

				JAXBDataParser jdp = new JAXBDataParser();

				ReferenceType rt = new ReferenceType();

				rt.setProperties(new PropertiesType());

				PropertyType pt = new PropertyType();
				pt.setName("className");
				pt.setValue("gov.va.med.nhin.adapter.results.ResultsType");

				rt.getProperties().getProperty().add(pt);

				pt = new PropertyType();
				pt.setName("returnProperty");
				pt.setValue(getReturnProperty(getNameWithoutExtension(file.getName())));

				rt.getProperties().getProperty().add(pt);

				Reference<String> reference = new Reference<String>(rt, null, null);
				System.out.println(file.getName());
				String xmlString = readFile(file.getAbsolutePath());
				List<String> l = new ArrayList<String>();
				l.add(xmlString);
				mdp.set(getNameWithoutExtension(file.getName()), jdp.parse(l, reference, null));
			}
		}

		org.w3c.dom.Document document = xmlTemplate.fillIn(mdp.getObject());

		FileOut(location + ".xml", document);

	}

	private static VisitsType createVisitsType() {
		VisitsType visitsType = new VisitsType();

		for (int i = 0; i < 1; i++) {
			visitsType.getVisit().add(createVisitType());
		}

		return visitsType;
	}

	/**
	 * @return
	 */

	private static VisitType createVisitType() {
		VisitType visitType = new VisitType();

		visitType.setApptStatus(createStringValueType());
		visitType.setArrivalDateTime(createFMDateTimeType());
		visitType.setCreditStopCode(createCodedValueType());
		visitType.setDateTime(createFMDateTimeType());
		visitType.setDepartureDateTime(createFMDateTimeType());
		visitType.setDisposition(createCodedValueType());
		visitType.setDocuments(createDocumentsType2());
		visitType.setDuration(createStringValueType());
		visitType.setFacility(createFacilityType());
		visitType.setId(createStringValueType());
		visitType.setLocation(createStringValueType());
		visitType.setPatientClass(createStringValueType());
		visitType.setProviders(createProvidersType());
		visitType.setReason(createReasonType());
		visitType.setRoomBed(createStringValueType());
		visitType.setService(createStringValueType());
		visitType.setServiceCategory(createCodedValueType());
		visitType.setSpecialty(createStringValueType());
		visitType.setStopCode(createCodedValueType());
		visitType.setType(createCodedValueType());
		visitType.setVisitString(createStringValueType());
//		visitType.setPrimaryProvider(createStringValueType());
//		visitType.setReasonText(createStringValueType());

//		visitType.setDischargeDateTime(createStringValueType());

		return visitType;
	}

	/**
	 * @return
	 */
	private static ReasonType createReasonType() {
		ReasonType reasonType = new ReasonType();
		reasonType.setCode(createString());
		reasonType.setName(createString());
		reasonType.setNarrative(createString());
		reasonType.setVuid(createString());

		return reasonType;

	}

	/**
	 * @return
	 */
	private static Providers createProvidersType() {
		Providers providers = new Providers();

		for (int i = 0; i < 1; i++) {
			providers.getProvider().add(createProviderType(i == 0));
		}

		return providers;
	}

//	private static AppointmentType.Providers createAppointmentTypeProvidersType() {
//		AppointmentType.Providers providers = new AppointmentType.Providers();
//
//		for (int i = 0; i < 1; i++) {
//			providers.getProvider().add(createProviderType(i == 0));
//		}
//
//		return providers;
//	}

	/**
	 * @return
	 */
	private static Documents createDocumentsType2() {
		Documents documentsType = new Documents();

		for (int i = 0; i < 25; i++) {
			documentsType.getDocument().add(createDocumentType2());
		}

		return documentsType;
	}

	/**
	 * @return
	 */
	private static DocumentReferenceType createDocumentType2() {

		DocumentReferenceType documentReferenceType = new DocumentReferenceType();
		documentReferenceType.setId(createString());
		documentReferenceType.setLocalTitle(createString());
		documentReferenceType.setNationalTitle(createString());
		
		if ( (System.currentTimeMillis() % 2) == 0) {
			documentReferenceType.setContent("One for all and all for one, Muskehounds are always ready. One for all and all for one, helping everybody. One for all and all for one, it's a pretty story. Sharing everything with fun, that's the way to be. One for all and all for one, Muskehounds are always ready. One for all and all for one, helping everybody. One for all and all for one, can sound pretty corny. If you've got a problem chum, think how it could be. Top Cat! The most effectual Top Cat! Who's intellectual close friends get to call him T.C., providing it's with dignity. Top Cat! The indisputable leader of the gang. He's the boss, he's a pip, he's the championship. He's the most tip top, Top Cat.");			
		} else {
			documentReferenceType.setContent("Hong Kong Phooey, number one super guy. Hong Kong Phooey, quicker than the human eye. He's got style, a groovy style, and a car that just won't stop. When the going gets tough, he's really rough, with a Hong Kong Phooey chop (Hi-Ya!). Hong Kong Phooey, number one super guy. Hong Kong Phooey, quicker than the human eye. Hong Kong Phooey, he's fan-riffic! Ulysses, Ulysses - Soaring through all the galaxies. In search of Earth, flying in to the night. Ulysses, Ulysses - Fighting evil and tyranny, with all his power, and with all of his might. Ulysses - no-one else can do the things you do. Ulysses - like a bolt of thunder from the blue. Ulysses - always fighting all the evil forces bringing peace and justice to all.");
		}
		
		return documentReferenceType;
	}

	private static FactorsType createFactorsType() {
		FactorsType FactorsType = new FactorsType();

		for (int i = 0; i < 1; i++) {
			FactorsType.getFactor().add(createFactorType());
		}

		return FactorsType;
	}

	private static FactorType createFactorType() {

		FactorType FactorType = new FactorType();

//		FactorType.setCategory(createCodedValueType());
		FactorType.setComment(createStringValueType());
		FactorType.setEncounter(createStringValueType());
//		FactorType.setFacility(createFacilityType());
		FactorType.setId(createStringValueType());
		FactorType.setName(createStringValueType());
//		FactorType.setReferenceDateTime(createFMDateTimeType());
		FactorType.setSeverity(createStringValueType());

		return FactorType;
	}

//	private static DemographicsType createDemographicsType() {
//		DemographicsType demographicsType = new DemographicsType();
//		for (int i = 0; i < 1; i++) {
//			demographicsType.getDemographics().add(createPatientType());
//		}
//		return demographicsType;
//	}

//	private static DemographicsExtType createDemographicsExtType() {
//		DemographicsExtType demographicsExtType = new DemographicsExtType();
//
//		demographicsExtType.setAliasFamily(createStringValueType());
//		demographicsExtType.setAliasGiven(createStringValueType());
//		demographicsExtType.setAliasPrefix(createStringValueType());
//		demographicsExtType.setAliasSuffix(createStringValueType());
//		demographicsExtType.setDemographicsExt(createStringValueType());
//		demographicsExtType.setFacilityName(createStringValueType());
//		demographicsExtType.setFacilityNumber(createStringValueType());
//		demographicsExtType.setHomeAddressCity(createStringValueType());
//		demographicsExtType.setHomeAddressPostal(createStringValueType());
//		demographicsExtType.setHomeAddressPostal(createStringValueType());
//		demographicsExtType.setHomeAddressState(createStringValueType());
//		demographicsExtType.setHomeAddressStreet(createStringValueType());
//		demographicsExtType.setMaritalStatus(createStringValueType());
//		demographicsExtType.setMaritalStatusCode(createStringValueType());
//		demographicsExtType.setMaritalStatusDisplay(createStringValueType());
//		demographicsExtType.setPhoneHome(createStringValueType());
//
//		return demographicsExtType;
//	}

	/**
	 * @param args
	 * @throws JAXBException 
	 * @throws TransformerException 
	 * @throws IOException 
	 */
	public static void main(String[] args) throws Exception {

		saveExemplar(createAppointmentsType(), "appointments.xml");

		saveExemplar(createRemindersType(), "reminders.xml");

		saveExemplar(createInsurancesType(), "insurances.xml");

//		saveExemplar(createDemographicsType(), "demographics.xml");

//		saveExemplar(createDemographicsExtsType(), "demographicsExt.xml");

		saveExemplar(createDocumentsType(), "documents.xml");

		saveExemplar(createAllergiesTypes(false), "allergies.xml");

		saveExemplar(createAllergiesTypes(true), "noknownallergies.xml");

		saveExemplar(createMedsTypes(), "medications.xml");

		saveExemplar(createLabsType(), "labs.xml");

		saveExemplar(createProceduresType(null), "procedures.xml");

		saveExemplar(createProceduresType("SR"), "futureprocedures.xml");

		saveExemplar(createProceduresType("RA"), "futureradiology.xml");
		// saveExemplar(createProceduresType(), "futureprocedures.xml");

		saveExemplar(createVisitsType(), "visits.xml");

		saveExemplar(createImmunizationsType(), "immunizations.xml");

		saveExemplar(createVitalsType(), "vitals.xml");

		saveExemplar(createProblemsType(), "problems.xml");

		saveExemplar(createFactorsType(), "factors.xml");

		saveExemplar(createOrdersType(), "orders.xml");

		saveExemplar(createRemindersType(), "reminders.xml");

	}

	/**
	 * @return
	 */
	private static OrdersType createOrdersType() {
		OrdersType ordersType = new OrdersType();
		for (int i = 0; i < 1; i++) {
			ordersType.getOrder().add(createOrderType());
		}
		return ordersType;
	}

	/**
	 * @return
	 */
	private static OrderType createOrderType() {
		OrderType orderType = new OrderType();

		orderType.setAcknowledgements(createAcknowledgementsType());
		orderType.setContent(RandomStringUtils.randomAlphabetic(10));
		orderType.setEntered(createFMDateTimeType());
		orderType.setFacility(createFacilityType());
		orderType.setGroup(createStringValueType());
		orderType.setId(createStringValueType());
		orderType.setLocation(createCodedValueType());
		orderType.setName(createCodedValueType());
		orderType.setProvider(createProviderType(false));
		orderType.setService(createStringValueType());
		orderType.setStart(createFMDateTimeType());
		orderType.setStatus(createCodedValueType());
		orderType.setStop(createFMDateTimeType());
//		orderType.setOrderInstructions(createStringValueType(orderType.getName().getName() + " -  " +
//				orderType.getContent().getValue()));

		return orderType;

	}

	/**
	 * @return
	 */
	private static Acknowledgements createAcknowledgementsType() {
		Acknowledgements acknowledgements = new Acknowledgements();
		for (int i = 0; i < 1; i++) {
			acknowledgements.getAcknowledgement().add(createCodeNameDateType());
		}
		return acknowledgements;

	}

	/**
	 * @return
	 */
	private static CodeNameDateType createCodeNameDateType() {
		CodeNameDateType codeNameDateType = new CodeNameDateType();

		codeNameDateType.setCode(RandomStringUtils.randomAlphanumeric(5));
		codeNameDateType.setDate(NumberUtils.createBigDecimal(RandomStringUtils.randomNumeric(10)));
		codeNameDateType.setName(RandomStringUtils.randomAlphanumeric(5));

		return codeNameDateType;
	}

	/**
	 * @return
	 */
	private static RemindersType createRemindersType() {
		RemindersType remindersType = new RemindersType();
		for (int i = 0; i < 1; i++) {
			remindersType.getReminder().add(createReminderType());
		}
		return remindersType;
	}

	/**
	 * @return
	 */
	private static ReminderType createReminderType() {
		ReminderType reminderType = new ReminderType();

		reminderType.setClazz(createStringValueType());
		reminderType.setDue(createStringValueType());
		reminderType.setFacility(createFacilityType());
		reminderType.setId(createStringValueType());
		reminderType.setLastDone(createStringValueType());
		reminderType.setName(createStringValueType());
		reminderType.setStatus(createStringValueType());
		reminderType.setText(createStringValueType());
		reminderType.setUsage(createStringValueType());
//		reminderType.setWellness(createStringValueType("Wellness"));
		/*
		 * Influenza Vaccine (LAST DONE: 05/05/2013)
		 * OR
		 * Influenza Vaccine (LAST DONE: Unlnown)
		 */
//		reminderType.setLastDoneValue(createStringValueType(reminderType.getName().getValue() + " LAST DONE (" +
//				reminderType.getLastDone().getValue() + ")"));

		return reminderType;
	}

	private static StringValueType createStringValueType(String value) {
		StringValueType stringValueType = new StringValueType();
		stringValueType.setValue(value);
		return stringValueType;
	}

	/**
	 * @return
	 */
	private static AppointmentsType createAppointmentsType() {
		AppointmentsType appointmentsType = new AppointmentsType();

		for (int i = 0; i < 1; i++) {
			appointmentsType.getAppointment().add(createAppointmentType());
		}

		return appointmentsType;
	}

	/**
	 * @return
	 */
	private static AppointmentType createAppointmentType() {
		AppointmentType appointmentType = new AppointmentType();

		appointmentType.setApptStatus(createStringValueType());
		appointmentType.setClinicStop(createCodedValueType());
		appointmentType.setDateTime(createFMDateTimeType());
		appointmentType.setFacility(createFacilityType());
		appointmentType.setId(createStringValueType());
		appointmentType.setLocation(createStringValueType());
		appointmentType.setPatientClass(createStringValueType());
//		appointmentType.setProviders(createAppointmentTypeProvidersType());
		appointmentType.setService(createStringValueType());
//		appointmentType.setServiceCategory(createStringValueType());
		appointmentType.setType(createCodedValueType());
		appointmentType.setVisitString(createStringValueType());

		return appointmentType;
	}

	/**
	 * @return
	 */
	private static InsurancesType createInsurancesType() {
		InsurancesType insurancesType = new InsurancesType();
//		for (int i = 0; i < 1; i++) {
//			insurancesType.getInsurance().add(createInsuranceType());
//		}
		return insurancesType;
	}

	/**
	 * @return
	 */
	private static InsuranceType createInsuranceType() {
		InsuranceType insuranceType = new InsuranceType();
		insuranceType.setCompany(createCompany());
		insuranceType.setEffectiveDate(createFMDateTimeType());
		insuranceType.setExpirationDate(createFMDateTimeType());
		insuranceType.setFacility(createFacilityType());
		insuranceType.setGroupName(createStringValueType());
		insuranceType.setGroupNumber(createStringValueType());
		insuranceType.setId(createStringValueType());
		insuranceType.setInsuranceType(createCodedValueType());
		insuranceType.setMemberID(createStringValueType());
		insuranceType.setRelationship(createStringValueType());
//		insuranceType.setSubscriber(createSubscriber());

		return insuranceType;
	}

	/**
	 * @return
	 */
//	private static Subscriber createSubscriber() {
//		Subscriber subscriber = new Subscriber();
//		subscriber.setAddress(createAddressType());
//		subscriber.setDob(createStringValueType());
//		subscriber.setId(createStringValueType());
//		subscriber.setName(createStringValueType());
//		subscriber.setTelecom(createStringValueType());
//		return subscriber;
//	}

	/**
	 * @return
	 */
	private static Company createCompany() {
		Company company = new Company();
//		company.setAddress(createAddressType());
//		company.setId(createStringValueType());
//		company.setName(createStringValueType());
//		company.setTelecom(createStringValueType());
		return company;

	}

	/**
	 * @return
	 */
//	private static DemographicsExtsType createDemographicsExtsType() {
//		DemographicsExtsType demographicsExtsType = new DemographicsExtsType();
//
//		for (int i = 0; i < 1; i++) {
//			demographicsExtsType.getDemographicsExt().add(createDemographicsExtType());
//		}
//		return demographicsExtsType;
//	}

	private static void saveExemplar(Object exemplar, String fileName) throws Exception {

		Writer writer = new FileWriter("src/test/resources/" + fileName);
		JAXBContext context = JAXBContext.newInstance(ResultsType.class);
		ResultsType resultsType = new ResultsType();

		resultsType.getResults().add((Serializable) exemplar);

		Marshaller m = context.createMarshaller();
		m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);

		// Marshaller marshaller = jc.createMarshaller();
		// marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
		// marshaller.marshal(new JAXBElement<ResultsType>(new QName("uri","local"), ResultsType.class, resultsType,writer);

		// m.marshal(new JAXBElement<ResultsType>(new QName("uri", "local"), ResultsType.class, resultsType), writer);

		m.marshal(resultsType, writer);

	}

	private static void SystemOut(org.w3c.dom.Document document) throws TransformerException {

		TransformerFactory tFactory = TransformerFactory.newInstance();
		Transformer transformer = tFactory.newTransformer();

		DOMSource source = new DOMSource(document);
		ByteArrayOutputStream baos = new ByteArrayOutputStream();

		StreamResult result = new StreamResult(baos);
		transformer.transform(source, result);

		System.out.println(baos.toString());

		ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());

	}

	private static void FileOut(String fileName, org.w3c.dom.Document document) throws TransformerException {

		TransformerFactory tFactory = TransformerFactory.newInstance();
		Transformer transformer = tFactory.newTransformer();

		DOMSource source = new DOMSource(document);

		StreamResult streamResult = new StreamResult(new File(fileName));
		transformer.transform(source, streamResult);

		ByteArrayOutputStream baos = new ByteArrayOutputStream();

		StreamResult result = new StreamResult(baos);
		transformer.transform(source, result);

		// System.out.println(baos.toString());

		ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());

	}

}
