package gov.va.med.nhin.adapter.datamanager;

import gov.va.med.nhin.adapter.datamanager.config.QueryType;
import gov.va.med.nhin.adapter.datamanager.config.ReferenceType;
import gov.va.med.nhin.adapter.datamanager.parsers.JAXBDataParser;
import gov.va.med.nhin.adapter.datamanager.translators.FilterDataTranslator;
import gov.va.med.nhin.adapter.results.FMDateTimeType;
import gov.va.med.nhin.adapter.utils.config.PropertiesType;
import gov.va.med.nhin.adapter.utils.config.PropertyType;
import gov.va.med.nhin.adapter.xmlutils.XMLTemplate;
import gov.va.med.nhin.adapter.xmlutils.XMLTemplateFactory;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;

import javax.xml.bind.JAXBException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.NumberUtils;
import org.apache.commons.lang.RandomStringUtils;

//import com.google.gson.Gson;

public class ExecuteTransform {

	private static final Map<String, String> BILLY_SOURCE_TO_PROPERTY = Collections
			.unmodifiableMap(new HashMap<String, String>() {
				{
					put("VPR_Orders", "futureOrders");
					put("VPR_Radiologies", "futureRadiology");
					put("VPR_Procedures", "futureProcedures");
					put("VPR_Appointments", "appointments");
					put("VPR_Visits", "visits");
					put("VPR_Vitals", "vitals");
					put("VPR_PANELS", "labs");
					put("VPR_Meds", "medications");
					put("VPR_Surgeries", "surgeries");
					//put("VPR_AdvanceDirective", "documents");
					//put("VPR_DischargeSummary", "dischargeSummaries");
					//put("VPR_Demographics", "demographics");
					put("VPR_Radiologies", "radiologies");
					put("VPR_Orders", "futureOrders");
					//put("VPR_Pathologies", "pathologies");
					put("VPR_Vitals", "vitals");
					put("VPR_Demographics", "participants");
					
					//  put("VPR_ClinicalProcedureNotes", "clinicalProcedureNotes");
					
					//put("VPR_Payers", "insurancePolicies");
					
					
					
					
				 
					
					
					
					
					
					
					
				}
			});
	
	private static final Map<String, String> SOURCE_TO_PROPERTY = Collections
			.unmodifiableMap(new HashMap<String, String>() {
				{
					put("VistA.findOrders2", "futureOrders");
					put("VistA.findRadiology2", "futureRadiology");
					put("VistA.findFutureProcedures2", "futureProcedures");
					put("VistA.findAppointments2", "appointments");
					put("VistA.findVisits2", "visits");
					put("VistA.findVitals2", "vitals");
					put("VistA.findLabs2", "labs");
					put("VistA.findMedications2", "medications");
					put("VistA.findSurgeries", "surgeries");
					put("VistA.findAdvanceDirective", "documents");
					put("VistA.findDischargeSummary", "dischargeSummaries");
					put("MPI.findDemographics", "demographics");
					put("VistA.findRadiologies", "radiologies");
					put("VistA.findOrders2", "futureOrders");
					put("VistA.findPathologies", "pathologies");
					put("VistA.findVitals2", "vitals");
					put("VistA.findDemographics2", "participants");
					
					put("VistA.findClinicalProcedureNotes", "clinicalProcedureNotes");
					
					put("VistA.findPayers", "insurancePolicies");
					
					
					
					
				 
					
					
					
					
					
					
					
				}
			});

	@SuppressWarnings("rawtypes")
	private static void run(String[] queries) throws TransformerException {
		MappedDataProxy mdp = new MappedDataProxy();

		mdp.setObject(new java.util.HashMap());

		for (String queryName : queries) {
			DataQueryImpl dataQuery = dataManager.getQuery(queryName);
			dataQuery.setParameter("icn", "1012638925V204624");
			List results = null;
			try
			{
				results = dataQuery.getResults();
			}
			catch (Exception e1)
			{
				// TODO Auto-generated catch block
				System.out.println(queryName + " failed to load results");
				//e1.printStackTrace();
			}
			if (results != null)
				mdp.set(SOURCE_TO_PROPERTY.get(dataQuery.getName()), results);
		}
		
		

		//
		


		mdp.set("documentUniqueId", "documentUniqueId");
		mdp.set("creationTime", createFMDateTimeType().toString());
		mdp.set("patientId", "patientId");
		mdp.set("authenticatorOID", "authenticatorOID");
		mdp.set("authenticatorName", "authenticatorName");
		mdp.set("beginDate", createFMDateTimeType().toString());
		mdp.set("endDate", createFMDateTimeType().toString());
		
//		Gson gson = new Gson(); 
//		String json = gson.toJson(mdp.getObject()); 
//		
//		System.out.println(json);

		org.w3c.dom.Document document = xmlTemplate.fillIn(mdp.getObject());
		
		org.w3c.dom.Element e = document.getElementById("endEncounterDescription1");
		
		
		 
		FileOut("results.xml", document);

	}

	static DataManagerImpl dataManager = null;
	
	static XMLTemplate xmlTemplate = null;

	 
	@SuppressWarnings({ "rawtypes", "unchecked" })
	static void initialize(String dataConfigPath,String mappingPath,final String extractLocation){
		
		 
		
		dataManager = DataManagerFactory
				.getDataManager("DM-Common", dataConfigPath);

		// Set all the adapters for vista to mock xml local ones
		for (QueryType queryType : dataManager.config.getQueries().getQuery()) {
			for (String queryName : queryType.getName()) {
			 

					DataQueryImpl dq = dataManager.getQuery(queryName);

					DataAdapter mockVistaAdapter = new DataAdapter() {
 					public List getData(DataQuery dataQuery) {
							List list = new ArrayList<String>();

							try {
								
								if (dataQuery.getName().startsWith("MPI.")) {
									String result = readFile(extractLocation+dataQuery.getName()
											+ ".txt");
									
									list.add(result);
									
								}
								
								if (dataQuery.getName().startsWith("VistA.")) {
									String result = readFile(extractLocation+dataQuery.getName()
											+ ".xml");
									
									list.add(result);
									
								}

							} catch (IOException e) {
								return list;
							}
							return list;
						}
					};
					dataManager.setDataAdapter(dq.getQueryType().getAdapter()
							.getName(), mockVistaAdapter);
		 
				
				
			}
		}
		
		dataManager.setTranslationDef("STSTranslate","gov.va.med.nhin.adapter.datamanager.translators.PassThroughTranslator");
		dataManager.setTranslationDef("STSLookup","gov.va.med.nhin.adapter.datamanager.translators.PassThroughTranslator");
		dataManager.setTranslationDef("Lookup","gov.va.med.nhin.adapter.datamanager.translators.PassThroughTranslator");
	
		
	 
	 
		
		
		
		
		
		 xmlTemplate = XMLTemplateFactory
					.getXMLTemplate(mappingPath);

	}

	/**
	 * @param args
	 * @throws Exception
	 */
	public static void main(String[] args) throws Exception {

		CommandLineParser parser = new BasicParser();

		Options options = new Options();

		options.addOption("dc", "dataconfig", true, "Location of DataConfig.xml");

		options.addOption("m", "mapping", true, "Location of Mapping File");
		
		options.addOption("e", "extracts", true, "Location of Extract Files");

		CommandLine cmd = parser.parse(options, args);

		String dataConfigPath = null;
		if (cmd.hasOption("dc")){
			dataConfigPath = cmd.getOptionValue("dc");
		} else {
			dataConfigPath = "../AdapterBundle/src/main/resources/config/DNS  N_Adapter/dataManagerConfig.xml";
		}
 		
		String mappingPath = null;
		if (cmd.hasOption("m") ) {
			mappingPath = cmd.getOptionValue("m");
		} else {
			mappingPath  = "../AdapterBundle/src/main/resources/config/DNS  N_Adapter/cccd-mapping.xml";
		}
		
		String extractFileLocation=null;
		if (cmd.hasOption("e") ) {
			extractFileLocation = cmd.getOptionValue("e");
		} else {									
			extractFileLocation = "src/test/resources/";
		}
		

		initialize(dataConfigPath,mappingPath,extractFileLocation);
		
// 		run("VistA.findSurgeries");
//		run("VistA.findVisits2");
		
	//	run("VistA.findDischargeSummary");
		
	//	run("MPI.findDemographics");
	//	run("MPI.findDemographics");
		
//		String[] queries={"MPI.findDemographics","VistA.findDischargeSummary","VistA.findSurgeries","VistA.findVisits2","VistA.findOrders2","VistA.findRadiologies","VistA.findAdvanceDirective"};

//		String[] queries = {"VistA.findRadiologies","VistA.findLabs2","VistA.findPathologies"};
//		String[] queries ={"VistA.findDischargeSummary"};
		
		 File dir = new File(extractFileLocation);
		  File[] directoryListing = dir.listFiles();
		  
		  ArrayList<String> files = new ArrayList<String>();
		  if (directoryListing != null) {
		    for (File child : directoryListing) {
		    	 int dot = child.getName().lastIndexOf(".");
		    	    
		//    System.out.println();
		    	 files.add(child.getName().substring(0,dot));
		    }
		  } else {
		    // Handle the case where dir is not really a directory.
		    // Checking dir.isDirectory() above would not be sufficient
		    // to avoid race conditions with another process that deletes
		    // directories.
		  }
		 
		  
		  String[] queries = new String[files.size()];
		  queries = files.toArray(queries);
		  
//		String[] queries = {"VistA.findRadiologies"}; //"VistA.findPayers","VistA.findClinicalProcedureNotes" };
//		, , "VistA.findDemographics2","VistA.findClinicalProcedureNotes"
//				"MPI.findDemographics", "VistA.findDischargeSummary",
//				"VistA.findLabs2", "VistA.findPathologies",
//				"VistA.findRadiologies", "VistA.findVisits2",
//				"VistA.findAdvanceDirective", "VistA.findFutureRadiologies",
//				"VistA.findOrders2", "VistA.findProcedures2",
//				"VistA.findSurgeries" };
		
		run(queries);
		

	}

	private static final Level FINEST = null;

	/*
	 * Lifted from GUAVA
	 */
	public static String getFileExtension(String fileName) {

		int dotIndex = fileName.lastIndexOf('.');
		return (dotIndex == -1) ? "" : fileName.substring(dotIndex + 1);
	}

	public static String getNameWithoutExtension(String fileName) {

		int dotIndex = fileName.lastIndexOf('.');
		return (dotIndex == -1) ? fileName : fileName.substring(0, dotIndex);
	}

	static String readFile(String fileName) throws IOException {
		BufferedReader br = new BufferedReader(new FileReader(fileName));
		try {
			StringBuilder sb = new StringBuilder();
			String line = br.readLine();

			while (line != null) {
				sb.append(line);
				sb.append("\n");
				line = br.readLine();
			}
			return sb.toString();
		} finally {
			br.close();
		}
	}

	private static String getReturnProperty(String extractName) {

		if ("allergies".equals(extractName)) {
			return "results[0].allergy";
		}

		if ("noknownallergies".equals(extractName)) {
			return "results[0].allergy";
		}

		if ("documents".equals(extractName)) {
			return "results[0].document";
		}

		if ("medications".equals(extractName)) {
			return "results[0].med";
		}

		if ("visits".equals(extractName)) {
			return "results[0].visit";
		}

		if ("immunizations".equals(extractName)) {
			return "results[0].immunization";
		}

		if ("labs".equals(extractName)) {
			return "results[0].lab";
		}

		if ("vitals".equals(extractName)) {
			return "results[0].vital";
		}

		if ("problems".equals(extractName)) {
			return "results[0].problem";
		}

		if ("procedures".equals(extractName)) {
			return "results[0].procedure";
		}

		if ("factors".equals(extractName)) {
			return "results[0].factor";
		}

		if ("demographics".equals(extractName)) {
			return "results[0].demographics";
		}

		if ("demographicsExt".equals(extractName)) {
			return "results[0].demographicsExt";
		}

		if ("insurances".equals(extractName)) {
			return "results[0].insurance";
		}

		if ("appointments".equals(extractName)) {
			return "results[0].appointment";
		}

		if ("futureprocedures".equals(extractName)) {
			return "results[0].procedure";
		}

		if ("futureradiology".equals(extractName)) {
			return "results[0].procedure";
		}

		if ("orders".equals(extractName)) {
			return "results[0].order";
		}

		if ("reminders".equals(extractName)) {
			return "results[0].reminder";
		}

		return "";

	}

	static SimpleDateFormat resultFormat = new SimpleDateFormat("yyyyMMddmmss");

	static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");

	private static FMDateTimeType createFMDateTimeType() {
		FMDateTimeType fMDateTimeType = new FMDateTimeType();

		fMDateTimeType.setValue(NumberUtils.createBigDecimal(DATE_FORMAT
				.format(new Date(Math.abs(System.currentTimeMillis()
						- Long.valueOf(RandomStringUtils.randomNumeric(10))
								.longValue())))));
		return fMDateTimeType;
	}

	@SuppressWarnings("rawtypes")
	private static void parseAndFillIn(File scenario) throws Exception {

		String location = "results" + System.getProperty("file.separator")
				+ scenario.getName() + System.getProperty("file.separator")
				+ scenario.getName() + resultFormat.format(new Date());

		File theDir = new File("results"); // Defining Directory/Folder Name

		if (!theDir.exists()) { // Checks that Directory/Folder Doesn't Exists!
			theDir.mkdir();
		}

		theDir = new File("results" + System.getProperty("file.separator")
				+ scenario.getName()); // Defining Directory/Folder Name

		if (!theDir.exists()) { // Checks that Directory/Folder Doesn't Exists!
			theDir.mkdir();
		}

		java.util.logging.LogManager.getLogManager().reset();

		Enumeration<String> names = java.util.logging.LogManager
				.getLogManager().getLoggerNames();

		Handler handler = new FileHandler(location + "Log.xml");
		;

		while (names.hasMoreElements()) {
			String loggerName = names.nextElement();

			java.util.logging.LogManager.getLogManager().getLogger(loggerName)
					.addHandler(handler);
			java.util.logging.LogManager.getLogManager().getLogger(loggerName)
					.setLevel(FINEST);

		}

		XMLTemplate xmlTemplate = XMLTemplateFactory
				.getXMLTemplate("cccd-mapping.xml");

		File[] files = scenario.listFiles(new FileFilter() {
			public boolean accept(File file) {

				return file.isFile()
						&& getFileExtension(file.getName()).equalsIgnoreCase(
								"XML");
			}
		});

		MappedDataProxy mdp = new MappedDataProxy();

		mdp.setObject(new java.util.HashMap());

		for (File file : files) {
			if (file.isFile()) {

				JAXBDataParser jdp = new JAXBDataParser();

				ReferenceType rt = new ReferenceType();

				rt.setProperties(new PropertiesType());

				PropertyType pt = new PropertyType();
				pt.setName("className");
				pt.setValue("gov.va.med.nhin.adapter.results.ResultsType");

				rt.getProperties().getProperty().add(pt);

				pt = new PropertyType();
				pt.setName("returnProperty");
				pt.setValue(getReturnProperty(getNameWithoutExtension(file
						.getName())));

				rt.getProperties().getProperty().add(pt);

				Reference<String> reference = new Reference<String>(rt, null,
						null);
				System.out.println(file.getName());
				String xmlString = readFile(file.getAbsolutePath());
				List<String> l = new ArrayList<String>();
				l.add(xmlString);

				FilterDataTranslator fdt = new FilterDataTranslator();

				Object input;
				Object result;

				List ll = jdp.parse(l, reference, null);

				// pt = new PropertyType();
				// pt.setName("whereProperty");
				// pt.setValue("role");
				//
				// rt.getProperties().getProperty().add(pt);
				//
				// pt = new PropertyType();
				// pt.setName("wherePropertyValue");
				// pt.setValue("P");
				//
				// rt.getProperties().getProperty().add(pt);
				//
				// pt = new PropertyType();
				// pt.setName("resultProperty");
				// pt.setValue("name");
				//
				// rt.getProperties().getProperty().add(pt);
				//
				// for (Object o : ll) {
				//
				// WrapDynaBean asdf = new WrapDynaBean(o);
				//
				// asdf.set("asdfasdf", "asdfasdf");
				//
				// // PropertyUtils.setProperty(asdf, "asdfasdf",
				// "asdfasdfasdf");
				//
				// // System.out.println(PropertyUtils.getProperty(o,
				// "providers"));
				// //
				// //
				// System.out.println("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa---------------->"
				// +
				// // fdt.translate(PropertyUtils.getProperty(o,
				// "providers.provider"), null, reference, null));
				// }

				// rt.Reference<String> translation = new Reference<String>(rt,
				// null, null);
				// DataQuery dataQuery;
				// fdt.translate(input, result, translation, dataQuery);

				/*
				 * <field> <name>primaryProvider</name>
				 * <source>providers</source> <fieldType>STRING</fieldType>
				 * <translations> <reference> <name>Filter</name>
				 * <utils:properties> <utils:property>
				 * <utils:name>whereProperty</utils:name>
				 * <utils:value>role</utils:value> </utils:property>
				 * <utils:property> <utils:name>wherePropertyValue</utils:name>
				 * <utils:value>P</utils:value> </utils:property>
				 * <utils:property> <utils:name>resultProperty</utils:name>
				 * <utils:value>name</utils:value> </utils:property>
				 * </utils:properties> </reference> </translations> </field>
				 */

				if ("demographics".equals(getNameWithoutExtension(file
						.getName()))
						|| "demographicsExt"
								.equals(getNameWithoutExtension(file.getName()))) {
					mdp.set(getNameWithoutExtension(file.getName()), ll.get(0));
				} else {

					mdp.set(getNameWithoutExtension(file.getName()), ll);

				}

			}
		}

		mdp.set("documentUniqueId", "documentUniqueId");
		mdp.set("creationTime", createFMDateTimeType().toString());
		mdp.set("patientId", "patientId");
		mdp.set("authenticatorOID", "authenticatorOID");
		mdp.set("authenticatorName", "authenticatorName");
		mdp.set("beginDate", createFMDateTimeType().toString());
		mdp.set("endDate", createFMDateTimeType().toString());

		org.w3c.dom.Document document = xmlTemplate.fillIn(mdp.getObject());
		FileOut(location + ".xml", document);

	}

	/**
	 * @param args
	 * @throws JAXBException
	 * @throws TransformerException
	 * @throws IOException
	 */
	public static void main2(String[] args) throws Exception {

		String xmlLocation;
		if (args.length == 1) {
			xmlLocation = args[0];
		} else {
			xmlLocation = ".";
		}

		File fl = new File(xmlLocation);
		File[] files = fl.listFiles(new FileFilter() {
			public boolean accept(File file) {

				return file.isDirectory();
			}
		});

		for (File file : files) {
			parseAndFillIn(file);
		}

	}

	@SuppressWarnings("unused")
	private static void SystemOut(org.w3c.dom.Document document)
			throws TransformerException {

		TransformerFactory tFactory = TransformerFactory.newInstance();
		Transformer transformer = tFactory.newTransformer();

		DOMSource source = new DOMSource(document);
		ByteArrayOutputStream baos = new ByteArrayOutputStream();

		StreamResult result = new StreamResult(baos);
		transformer.transform(source, result);

		System.out.println(baos.toString());

		new ByteArrayInputStream(baos.toByteArray());

	}

	private static void FileOut(String fileName, org.w3c.dom.Document document)
			throws TransformerException {

		TransformerFactory tFactory = TransformerFactory.newInstance();
		Transformer transformer = tFactory.newTransformer();

		DOMSource source = new DOMSource(document);

		StreamResult streamResult = new StreamResult(new File(fileName));
		transformer.transform(source, streamResult);

		ByteArrayOutputStream baos = new ByteArrayOutputStream();

		StreamResult result = new StreamResult(baos);
		transformer.transform(source, result);

		new ByteArrayInputStream(baos.toByteArray());

	}

}
