package gov.va.med.nhin.adapter.sensitiveInfo;

import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.datamanager.SmartHashMap;

public class SensitiveInfoFilter implements DataTranslator
{
	private static final Logger logger = LoggerFactory.getLogger(SensitiveInfoFilter.class.getName());
	private static final String SENSITIVE_INFO_SLOT = "FILTER_SENSITIVE";

	@Override
	public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
	{
		Object ret = input;
		logger.trace("checking if input is smart hash map");
		logger.trace("dataQuery.getParameter(SENSITIVE_INFO_SLOT):" + dataQuery.getParameter(SENSITIVE_INFO_SLOT));
		logger.trace("dataQuery.getParameterNames():" + dataQuery.getParameterNames());

                if (logger.isTraceEnabled()) {
                    for(String test : dataQuery.getParameterNames())
                    {
                            logger.trace("dataQuery Parameter:" + test);
                    }
                }
                
		boolean doFilterParse = Boolean.parseBoolean((String) dataQuery.getParameter(SENSITIVE_INFO_SLOT));

		logger.trace("doFilter:" + doFilterParse + ", dataQuery:" + dataQuery);

		// Stop processing.
		if(!doFilterParse)
		{
			return input;
		}

		try
		{
			if(input instanceof SmartHashMap)
			{
				logger.trace("calling is filtering required");
				SensitiveInfoManager bean = (SensitiveInfoManager) new InitialContext().lookup("SensitiveInfoBean#" + SensitiveInfoManagerRemote.class.getName());
				boolean filteringRequired = bean.isFilteringRequired((SmartHashMap) input);
				logger.trace("filteringRequired:" + filteringRequired);
				if(filteringRequired)
				{
					ret = bean.filterSensitiveData((SmartHashMap) input);
				}
			}
		}
		catch(NamingException nex)
		{
			logger.error("Error occurred: ", nex.getMessage(), nex);
		}

		return ret;
	}
}
