package gov.va.med.nhin.adapter.internalApp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.ejb.*;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.med.nhin.adapter.datamanager.internalApp.InternalAppFilterObj;
import gov.va.med.nhin.adapter.datamanager.internalApp.InternalAppOperations;

@TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
@Stateless(name = "InternalAppManager", mappedName = "InternalAppManager")
public class InternalAppManagerBean implements InternalAppManager
{
	private static final Logger logger = LoggerFactory.getLogger(InternalAppManagerBean.class.getName());

	private EntityManager entityManager;

	@PersistenceContext
	public void setEntityManager(EntityManager entityManager)
	{
		this.entityManager = entityManager;
	}

	@SuppressWarnings("unchecked")
	public Map<String, List<InternalAppFilterObj>> generateFiltersByNumber(final String facilityNumber)
	{
		Query query = entityManager.createNamedQuery("InternalAppFilterView.findByFacilityNumber");
		query.setParameter("facilityNumber", facilityNumber);
		List<InternalAppFilterView> dbList = query.getResultList();

		Map<String, List<InternalAppFilterObj>> filterMap = new HashMap<>();
		for(InternalAppFilterView dbObj : dbList)
		{
                                                            if (dbObj.getCondObjName() != null && dbObj.getCondFilterId() <= 0)
                                                            {
                                                                // we don't want to store this because it's not in use - COND_FILTER_ID must be > 0
                                                                // when a conditional filter isn't in use, it will be null or 0.
                                                                continue;
                                                            }
 			InternalAppFilterObj obj = new InternalAppFilterObj();
			obj.setFilterValue(dbObj.getParameter());
			obj.setObjectName(dbObj.getObjName());
			obj.setOperation(InternalAppOperations.valueOf(dbObj.getFilterName()));
                                                             // set conditional filter 
                                                            obj.setCondFilterValue(dbObj.getCondParameter());
                                                            obj.setCondObjectName(dbObj.getCondObjName());
                                                             if (dbObj.getCondFilterId() > 0)
                                                             {
                                                                     obj.setCondOperation(InternalAppOperations.values()[dbObj.getCondFilterId() - 1]);
                                                             }
  			if(dbObj.getRootName().contains("."))
			{
				// There is a sub name in the root. Parse and set accordingly.
				int location = dbObj.getRootName().indexOf(".");
				String sectionName = dbObj.getRootName().substring(0, location);
				String subName = dbObj.getRootName().substring(location + 1);
				obj.setSubRoot(subName);
				addItemToMap(filterMap, obj, sectionName);
			}
			else
			{
 				addItemToMap(filterMap, obj, dbObj.getRootName());
			}
		}

		logger.debug("size of filtermap: {}", filterMap.size());
		
		return filterMap;
	}

	private void addItemToMap(Map<String, List<InternalAppFilterObj>> map, final InternalAppFilterObj obj, final String root)
	{
		List<InternalAppFilterObj> filters;
		if(map.containsKey(root))
		{
			// Already have list started just need to add to it.
			filters = map.get(root);
			filters.add(obj);
		}
		else
		{
			// No list exists yet. Create one and add it to the map.
			filters = new ArrayList<InternalAppFilterObj>();
			filters.add(obj);
			map.put(root, filters);
		}
	}
        
 }
