package gov.va.med.nhin.adapter.facilitymanager;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.Table;

import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.annotations.CacheCoordinationType;
import org.eclipse.persistence.annotations.CacheType;

@Entity
@Cache(
		  type=CacheType.SOFT, // Cache everything until the JVM decides memory is low.
		  size=64000,  // Use 64,000 as the initial cache size.
		  expiry=360000,  // 1 minutes
		  coordinationType=CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS  // if cache coordination is used, only send invalidation messages.
		)
@Table(name="FACILITIES_OPERATIONS")
public class Operations
{
	private int id;

	private String inboundPD;
	private String inboundQD;
	private String inboundRD;

	private String outboundPD;
	private String outboundQD;
	private String outboundRD;

	private String onOffBoard;
	Facility facilities;

	public Operations()
	{

	}

	public Operations(int id, String inboundPD, String inboundQD, String inboundRD, String outboundPD, String outboundQD, String outboundRD, final String onOffBoard)
	{

		this.id = id;
		this.inboundPD = inboundPD;
		this.inboundQD = inboundQD;
		this.inboundRD = inboundRD;
		this.outboundPD = outboundPD;
		this.outboundQD = outboundQD;
		this.outboundRD = outboundRD;
		this.onOffBoard = onOffBoard;
	}

	@Id
	@Column(name = "FACILITY_ID", unique = true, nullable = false)
	public int getId()
	{
		return id;
	}

	public void setId(int id)
	{
		this.id = id;
	}

	@Column(name = "IN_ALLOW_PATIENT_DICOVERY", unique = true, nullable = false)
	public String getInboundPD()
	{
		return inboundPD;
	}

	public void setInboundPD(String inboundPD)
	{
		this.inboundPD = inboundPD;
	}

	@Column(name = "IN_ALLOW_DOC_QUERY", unique = true, nullable = false)
	public String getInboundQD()
	{
		return inboundQD;
	}

	public void setInboundQD(String inboundQD)
	{
		this.inboundQD = inboundQD;
	}

	@Column(name = "IN_ALLOW_DOC_RETRIEVE", unique = true, nullable = false)
	public String getInboundRD()
	{
		return inboundRD;
	}

	public void setInboundRD(String inboundRD)
	{
		this.inboundRD = inboundRD;
	}

	@Column(name = "OUT_ALLOW_PATIENT_DICOVERY", unique = true, nullable = false)
	public String getOutboundPD()
	{
		return outboundPD;
	}

	public void setOutboundPD(String outboundPD)
	{
		this.outboundPD = outboundPD;
	}

	@Column(name = "OUT_ALLOW_DOC_QUERY", unique = true, nullable = false)
	public String getOutboundQD()
	{
		return outboundQD;
	}

	public void setOutboundQD(String outboundQD)
	{
		this.outboundQD = outboundQD;
	}

	@Column(name = "OUT_ALLOW_DOC_RETRIEVE", unique = true, nullable = false)
	public String getOutboundRD()
	{
		return outboundRD;
	}

	public void setOutboundRD(String outboundRD)
	{
		this.outboundRD = outboundRD;
	}

	@Column(name = "ON_OFF_BOARD", unique = true, nullable = false)
	public String getOnOffBoard()
	{
		return onOffBoard;
	}

	public void setOnOffBoard(String onOffBoard)
	{
		this.onOffBoard = onOffBoard;
	}

	@OneToOne(mappedBy = "operations", cascade = CascadeType.ALL)
	public Facility getFacilities()
	{
		return facilities;
	}

	public void setFacilities(Facility facilities)
	{
		this.facilities = facilities;
	}
}
