package gov.va.med.nhin.adapter.facilitymanager;

import java.io.Serializable;
import java.util.Collection;

import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

/**
 *
 * @author David Vazquez
 */
@Entity
@Table(name = "ASSIGNING_AUTHORITIES")
@NamedQueries({ 
	@NamedQuery(name = "AssigningAuthority.findAll", query = "SELECT a FROM AssigningAuthority a"), 
	@NamedQuery(name = "AssigningAuthority.findByAssigningAuthorityId", query = "SELECT a FROM AssigningAuthority a WHERE a.assigningAuthorityId = :assigningAuthorityId"), 
	@NamedQuery(name = "AssigningAuthority.findByAssigningAuthorityOid", query = "SELECT a FROM AssigningAuthority a WHERE a.assigningAuthorityOid = :assigningAuthorityOid"), 
	@NamedQuery(name = "AssigningAuthority.findByAssigningAuthorityName", query = "SELECT a FROM AssigningAuthority a WHERE a.assigningAuthorityName = :assigningAuthorityName") })
@SequenceGenerator(name = "assigningAuthorityIdGenerator", sequenceName = "ASSIGNING_AUTHORITY_ID_SEQ", allocationSize = 1)
public class AssigningAuthority implements Serializable
{
	private static final long serialVersionUID = 1L;
	
	@Id
	@Basic(optional = false)
	@Column(name = "ASSIGNING_AUTHORITY_ID")
	@GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "assigningAuthorityIdGenerator")
	private Long assigningAuthorityId;
	@Basic(optional = false)
	@Column(name = "ASSIGNING_AUTHORITY_OID")
	private String assigningAuthorityOid;
	@Column(name = "ASSIGNING_AUTHORITY_NAME")
	private String assigningAuthorityName;
	@OneToMany(cascade = CascadeType.ALL, mappedBy = "assigningAuthority", fetch = FetchType.EAGER)
	private Collection<FacilityToAA> facilitiesToAAs;

	public AssigningAuthority()
	{
	}

	public AssigningAuthority(Long assigningAuthorityId)
	{
		this.assigningAuthorityId = assigningAuthorityId;
	}

	public AssigningAuthority(Long assigningAuthorityId, String assigningAuthorityOid)
	{
		this.assigningAuthorityId = assigningAuthorityId;
		this.assigningAuthorityOid = assigningAuthorityOid;
	}

	public Long getAssigningAuthorityId()
	{
		return assigningAuthorityId;
	}

	public void setAssigningAuthorityId(Long assigningAuthorityId)
	{
		this.assigningAuthorityId = assigningAuthorityId;
	}

	public String getAssigningAuthorityOid()
	{
		return assigningAuthorityOid;
	}

	public void setAssigningAuthorityOid(String assigningAuthorityOid)
	{
		this.assigningAuthorityOid = assigningAuthorityOid;
	}

	public String getAssigningAuthorityName()
	{
		return assigningAuthorityName;
	}

	public void setAssigningAuthorityName(String assigningAuthorityName)
	{
		this.assigningAuthorityName = assigningAuthorityName;
	}

	public Collection<FacilityToAA> getFacilitiesToAAs()
	{
		return facilitiesToAAs;
	}

	public void setFacilitiesToAAs(Collection<FacilityToAA> facilitiesToAAs)
	{
		this.facilitiesToAAs = facilitiesToAAs;
	}

	@Override
	public int hashCode()
	{
		int hash = 0;
		hash += (assigningAuthorityId != null ? assigningAuthorityId.hashCode() : 0);
		return hash;
	}

	@Override
	public boolean equals(Object object)
	{
		// TODO: Warning - this method won't work in the case the id fields are
		// not set
		if(!(object instanceof AssigningAuthority))
		{
			return false;
		}
		AssigningAuthority other = (AssigningAuthority) object;
		if((this.assigningAuthorityId == null && other.assigningAuthorityId != null) || (this.assigningAuthorityId != null && !this.assigningAuthorityId.equals(other.assigningAuthorityId)))
		{
			return false;
		}
		return true;
	}

	@Override
	public String toString()
	{
		return "gov.va.med.nhin.adapter.facilitymanager.AssigningAuthority[assigningAuthorityId=" + assigningAuthorityId + "]";
	}
}
