package gov.va.med.nhin.adapter.datamanager.translators;

import java.util.Properties;

import javax.naming.InitialContext;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.terminology.Terminology;
import gov.va.med.nhin.adapter.utils.config.PropertiesType;
import gov.va.med.nhin.adapter.utils.config.PropertyTypeUtils;

/**
 *
 * @author David Vazquez
 */
public class TerminologyLookupEJBDataTranslator implements DataTranslator
{
	private InitialContext context;

	public Object translate(Object input, Object result, Reference translationType, DataQuery dataQuery)
	{
		Object ret;
		try
		{
			String codeset = translationType.getProperty("codeset");
			String field = translationType.getProperty("field");
			ret = getTerminology(translationType).lookup(codeset, (String) input, field);
		}
		catch(Throwable t)
		{
			throw new DataManagerException("An error occurred looking up term.", t);
		}

		return ret;
	}

	private Terminology getTerminology(Reference translationType) throws Exception
	{
		if(context == null)
		{
			context = getInitialContext(translationType);
		}

		Terminology ret = (Terminology) context.lookup("Terminology#gov.va.med.nhin.adapter.terminology.TerminologyRemote");
		return ret;
	}

	private InitialContext getInitialContext(Reference translationType) throws Exception
	{
		InitialContext ret;

		PropertiesType propertiesType = translationType.getProperties("initialContextProperties");
		if(propertiesType != null)
		{
			Properties properties = PropertyTypeUtils.toProperties(propertiesType);
			ret = new InitialContext(properties);
		}
		else
		{
			ret = new InitialContext();
		}

		return ret;
	}
}
